/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkEnumeratedType;
import org.conqat.lib.simulink.builder.SimulinkVariant;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.na_0037", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkVariantConditionCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_MULTIPLE_VARIABLES = "Conditional expression %s uses multiple variables";
    private static final FindingPropertyList RECOMMENDED_ACTION_MULTIPLE_VARIABLES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Update the variant so that only one variable is used.");
    private static final String FINDING_MESSAGE_NOT_FOUND = "Simulink.Variant object or expression variable with name %s cannot be found";
    private static final FindingPropertyList RECOMMENDED_ACTION_NOT_FOUND = FindingPropertyList.singleton((String)"Recommended Action", (String)"Create a Simulink.Variant object.");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern MATLAB_IDENTIFIER_PATTERN = Pattern.compile("(?<!\\.)\\b([A-Za-z_]\\w+)\\b(?!\\.)");
    private static final Pattern MATLAB_IDENTIFIER_PROPERTY_ACCESS_PATTERN = Pattern.compile("([A-Za-z_]\\w+\\.[A-Za-z_]\\w+)");
    private static final Set<String> IGNORED_IDENTIFIERS = Set.of("true", "false");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        List<SimulinkDataDictionary> dictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        if (model == null || dictionaries.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (block.isOfType("VariantSink") || block.isOfType("VariantSource")) {
                String[] conditions = SimulinkVariantConditionCheck.getVariantControlValuesFromVariantSinkOrSourceBlock(model, block);
                Arrays.stream(conditions).forEach(condition -> this.checkVariantCondition((String)condition, block, dictionaries));
                continue;
            }
            if (!SimulinkUtils.isVariantSubsystem((SimulinkBlock)block)) continue;
            this.checkVariantSubsystem(block, dictionaries);
        }
    }

    private void checkVariantSubsystem(SimulinkBlock subsystem, List<SimulinkDataDictionary> dictionaries) {
        for (SimulinkBlock subBlock : subsystem.getSubBlocks()) {
            if (!subBlock.isOfType("SubSystem") && !subBlock.isOfType("ModelReference")) continue;
            this.checkVariantCondition(subBlock.getParameter("VariantControl"), subBlock, dictionaries);
        }
    }

    public static String[] getVariantControlValuesFromVariantSinkOrSourceBlock(SimulinkModel model, SimulinkBlock block) {
        String variantControlsParameter = block.getParameter("VariantControls");
        if (variantControlsParameter == null) {
            LOGGER.error("No 'VariantControls' parameter found in block " + String.valueOf(block));
            return new String[0];
        }
        return model.getParameter(variantControlsParameter).split("@");
    }

    private void checkVariantCondition(String variantCondition, SimulinkBlock block, List<SimulinkDataDictionary> dictionaries) {
        if (StringUtils.isEmpty((String)variantCondition)) {
            LOGGER.warn("No or empty variant condition detected for block with ID " + block.getId() + ".");
        }
        if ("(default)".equals(variantCondition)) {
            return;
        }
        Optional variant = SimulinkUtils.findDataDictionaryEntry(dictionaries, (String)variantCondition, SimulinkVariant.class);
        if (variant.isPresent()) {
            variantCondition = ((SimulinkVariant)variant.get()).getCondition();
        }
        List<String> plainIdentifiers = SimulinkVariantConditionCheck.extractAllPlainMatlabIdentifiers(variantCondition);
        this.checkUseOfSingleVariable(plainIdentifiers, variantCondition, block);
        List<String> propertyAccessExpressions = SimulinkVariantConditionCheck.extractMatlabPropertyAccessExpressions(variantCondition);
        this.checkVariableDefinitions(plainIdentifiers, propertyAccessExpressions, dictionaries, block);
    }

    private static List<String> extractMatlabPropertyAccessExpressions(String expression) {
        return SimulinkVariantConditionCheck.getMatchedPatterns(MATLAB_IDENTIFIER_PROPERTY_ACCESS_PATTERN, expression);
    }

    private static List<String> extractAllPlainMatlabIdentifiers(String expression) {
        return CollectionUtils.filter(SimulinkVariantConditionCheck.getMatchedPatterns(MATLAB_IDENTIFIER_PATTERN, expression), identifier -> !IGNORED_IDENTIFIERS.contains(identifier));
    }

    private static List<String> getMatchedPatterns(Pattern pattern, String expression) {
        Matcher matcher = pattern.matcher(expression);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    private void checkUseOfSingleVariable(List<String> variableIdentifiers, String variantCondition, SimulinkBlock block) {
        if (variableIdentifiers.size() > 1) {
            String message = String.format(FINDING_MESSAGE_MULTIPLE_VARIABLES, MarkupUtils.formatAsSourceCode((String)variantCondition));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_MULTIPLE_VARIABLES).createAndStore();
        }
    }

    private void checkVariableDefinitions(List<String> identifiers, List<String> propertyAccessExpressions, List<SimulinkDataDictionary> dictionaries, SimulinkBlock block) {
        identifiers.forEach(identifier -> {
            if (!CollectionUtils.anyMatch((Collection)dictionaries, dataDictionary -> dataDictionary.containsEntry(identifier))) {
                String message = String.format(FINDING_MESSAGE_NOT_FOUND, MarkupUtils.formatAsSourceCode((String)identifier));
                this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NOT_FOUND).createAndStore();
            }
        });
        propertyAccessExpressions.forEach(propertyAccessExpression -> {
            if (!CollectionUtils.anyMatch((Collection)dictionaries, dataDictionary -> SimulinkVariantConditionCheck.containsEnumWithValue(propertyAccessExpression, dataDictionary))) {
                String message = String.format(FINDING_MESSAGE_NOT_FOUND, MarkupUtils.formatAsSourceCode((String)propertyAccessExpression));
                this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NOT_FOUND).createAndStore();
            }
        });
    }

    private static boolean containsEnumWithValue(String propertyAccessExpression, SimulinkDataDictionary dataDictionary) {
        String[] parts = propertyAccessExpression.split("\\.");
        Optional entryOptional = dataDictionary.findEntry(parts[0]);
        if (entryOptional.isEmpty()) {
            return false;
        }
        ISimulinkDataDictionaryEntry entry = (ISimulinkDataDictionaryEntry)entryOptional.get();
        if (entry instanceof SimulinkEnumeratedType) {
            return ((SimulinkEnumeratedType)entry).hasItemValue(parts[1]);
        }
        return true;
    }
}

