/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.artifactory.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryArchiveIndex;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/artifactory/debug")
public class DebugArtifactoryRepositoryService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get artifactory debug information", description="Returns debug information collected from the artifactory repository connectors.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getArtifactoryDebugInformation() throws StorageException {
        return this.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        IndexSchema schema = this.getProjectStorageSystem().getSchema();
        for (String storeName : schema.getEntryNames()) {
            SchemaEntry entry = schema.getEntry(storeName);
            if (!entry.getIndexClass().equals(ArtifactoryArchiveIndex.class.getName())) continue;
            ArtifactoryArchiveIndex artifactoryArchiveIndex = (ArtifactoryArchiveIndex)this.getProjectStorageSystem().openProjectIndex(ArtifactoryArchiveIndex.class, storeName, null);
            writer.println(storeName);
            writer.println("========================================");
            writer.println(artifactoryArchiveIndex.getStoredDebugInfo());
            writer.println();
        }
    }
}

