/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.AuthenticationRequestHandler;
import com.teamscale.core.authenticate.IUserAuthenticator;
import com.teamscale.core.authenticate.SessionDuration;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/authentication")
public class AuthenticationService
extends ApiBase {
    @GET
    @Operation(summary="Get authenticator", description="Retrieves authenticator information", tags={"Users", "Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS})
    public AuthenticatorMappingReply getAuthenticatorInformation() throws StorageException {
        return this.createAuthenticatorDisplayMap("");
    }

    @GET
    @Operation(summary="Get authenticator", description="Retrieves authenticator information", tags={"Users", "Administration"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.USERS, permissions={EBasicPermission.EDIT}, entityPathParameter="username")
    @Path(value="{username}")
    public AuthenticatorMappingReply getAuthenticatorInformationForUser(@Parameter(description="User to retrieve authentication info for") @PathParam(value="username") String username) throws StorageException {
        return this.createAuthenticatorDisplayMap(username);
    }

    @PUT
    @Operation(summary="Update password", description="Updates the user password", tags={"Administration", "Users"}, responses={@ApiResponse(responseCode="400", description="Empty password provided or authenticator does not allow password changes"), @ApiResponse(responseCode="404", description="User could not be found")})
    @RequiresBasicPermission(scope=EBasicPermissionScope.USERS, permissions={EBasicPermission.EDIT}, entityPathParameter="username")
    @Path(value="{username}")
    public Response updatePassword(@RequestBody(required=true) PasswordChangeRequest changeRequest, @Context ContainerRequestContext requestContext) throws StorageException {
        UserIndex userIndex;
        if (AuthenticationService.isEmptyPassword(changeRequest.newPassword)) {
            throw new BadRequestException("Cannot set empty password!");
        }
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        AuthenticationManager authManager = AuthenticationManager.getInstance();
        User user = (User)UserUtils.wipeAfterUse((char[])changeRequest.oldPassword, arg_0 -> AuthenticationService.lambda$updatePassword$0(authManager, changeRequest, userIndex = this.openGlobalIndex(UserIndex.class), optionIndex, arg_0));
        if (user == null) {
            throw new BadRequestException("User %s could not be found or old password is incorrect!".formatted(changeRequest.username));
        }
        user = this.refillAuthenticatorToken(changeRequest, user, userIndex, authManager);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        AuthenticationService.updateSessions(user, this.getUser(), this.openGlobalIndex(SessionIndex.class), this.serviceInfo, requestContext).ifPresent(cookie -> responseBuilder.header("Set-Cookie", cookie));
        return responseBuilder.build();
    }

    private User refillAuthenticatorToken(PasswordChangeRequest changeRequest, User user, UserIndex userIndex, AuthenticationManager authManager) throws StorageException {
        user = userIndex.getUser(user.getUsername());
        CCSMAssert.isNotNull((Object)user, (String)("User '" + changeRequest.username + "' not found in user index even though their password was just updated."));
        String oldAuthenticator = user.getAuthenticator();
        CCSMAssert.isNotNull((Object)oldAuthenticator, () -> "Authenticator for user '" + changeRequest.username + "' was unexpectedly null.");
        String authenticatorName = AuthenticationManager.getAuthenticatorName((String)oldAuthenticator);
        IUserAuthenticator authenticator = authManager.getAuthenticator(authenticatorName);
        if (!authenticator.allowsPasswordChanges()) {
            throw new BadRequestException("The authenticator does not allow password changes!");
        }
        String authenticatorString = (String)UserUtils.wipeAfterUse((char[])changeRequest.newPassword, arg_0 -> ((IUserAuthenticator)authenticator).generateNewAuthenticator(arg_0));
        user.setAuthenticator(authenticatorString);
        userIndex.setUser(user, this.serviceInfo.getMessageBroker());
        return user;
    }

    public static Optional<NewCookie> updateSessions(User updatedUser, User currentUser, SessionIndex sessionIndex, ITeamscaleServiceInfo serviceInfo, ContainerRequestContext requestContext) throws StorageException {
        if (!currentUser.getUsername().equals(updatedUser.getUsername())) {
            UserUtils.invalidateUserSession((String)updatedUser.getUsername(), (SessionIndex)sessionIndex, (IMessageBroker)serviceInfo.getMessageBroker());
            return Optional.empty();
        }
        AuthenticationRequestHandler authenticationRequestHandler = serviceInfo.getAuthenticationRequestHandler();
        Optional sessionDuration = authenticationRequestHandler.getSessionDuration(requestContext, sessionIndex);
        UserUtils.invalidateUserSession((String)updatedUser.getUsername(), (SessionIndex)sessionIndex, (IMessageBroker)serviceInfo.getMessageBroker());
        if (sessionDuration.isEmpty() || !((SessionDuration)sessionDuration.get()).isSessionActive()) {
            return Optional.empty();
        }
        return Optional.of(authenticationRequestHandler.createSessionCookie(updatedUser, serviceInfo.getRequestBaseUri(), sessionIndex, null, (SessionDuration)sessionDuration.get()));
    }

    private AuthenticatorMappingReply createAuthenticatorDisplayMap(String username) throws StorageException {
        UserIndex index = this.openGlobalIndex(UserIndex.class);
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        User user = index.getUser(username);
        return AuthenticationService.createAuthenticatorDisplayMap(optionIndex, user);
    }

    private static AuthenticatorMappingReply createAuthenticatorDisplayMap(ServerOptionIndex optionIndex, User user) throws StorageException {
        AuthenticationManager authManager = AuthenticationManager.getInstance();
        AuthenticatorMappingReply reply = new AuthenticatorMappingReply();
        for (String authenticatorString : authManager.getAuthenticatorNames(optionIndex)) {
            String authenticatorName = AuthenticationManager.getAuthenticatorName((String)authenticatorString);
            IUserAuthenticator authenticator = authManager.getAuthenticator(authenticatorName);
            reply.canChangePassword.put(authenticatorString, authenticator.allowsPasswordChanges());
            reply.canSwitchAuthenticator.put(authenticatorString, authenticator.allowsSwitching());
        }
        if (user == null) {
            reply.active = "HashedStored";
        } else {
            String authenticator = user.getAuthenticator();
            Preconditions.checkState((authenticator != null ? 1 : 0) != 0, (String)"Authenticator for user '%s' was unexpectedly null.", (Object)StringEscapeUtils.escapeJava((String)user.getUsername()));
            String authenticatorName = AuthenticationManager.getAuthenticatorName((String)authenticator);
            reply.active = authManager.getAuthenticator(authenticatorName).getDisplayName(authenticator);
        }
        return reply;
    }

    public static boolean isEmptyPassword(char[] password) {
        if (password == null) {
            return true;
        }
        for (char character : password) {
            if (Character.isWhitespace(character)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ User lambda$updatePassword$0(AuthenticationManager authManager, PasswordChangeRequest changeRequest, UserIndex userIndex, ServerOptionIndex optionIndex, byte[] passwordBytes) throws StorageException {
        return authManager.authenticate(changeRequest.username, passwordBytes, userIndex, optionIndex, true);
    }

    public static class AuthenticatorMappingReply {
        @JsonProperty(value="canChangePassword")
        public Map<String, Boolean> canChangePassword = new HashMap<String, Boolean>();
        @JsonProperty(value="canSwitchAuthenticator")
        public Map<String, Boolean> canSwitchAuthenticator = new HashMap<String, Boolean>();
        @JsonProperty(value="active")
        public String active = null;
    }

    public static class PasswordChangeRequest {
        @JsonProperty(value="username")
        public String username;
        @JsonProperty(value="oldPassword")
        public char[] oldPassword;
        @JsonProperty(value="newPassword")
        public char[] newPassword;
    }
}

