/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/synchronization/groups")
public class SynchronizeGroupsService
extends ApiBase {
    @POST
    @Operation(summary="Synchronize groups", description="Synchronizes all groups with a remote server. Will also automatically update all users in the groups. In case groups are deleted on the server, the process will remove all users (and additional remote server information) from them, but will not delete them, in order to preserve access rights. Returns a list containing the names of the synchronized groups.", responses={@ApiResponse(responseCode="404", description="The given server could not be found")}, tags={"Users", "Groups"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS, EGlobalPermission.CREATE_GROUPS})
    public List<String> synchronizeAllGroups(@Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        try {
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            return toolProvider.createSynchronizeGroupsStrategy(serverName).synchronizeAllGroups();
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Operation(summary="Synchronize group", description="Synchronizes the given group with a remote server. Will also automatically update all users in the group. In case the group is deleted on the server, the process will remove all users (and additional remote server information) from it, but will not delete it, in order to preserve access rights.", responses={@ApiResponse(responseCode="404", description="The given server or group could not be found")}, tags={"Users", "Groups"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS, EGlobalPermission.CREATE_GROUPS})
    @Path(value="{groupName}")
    public void synchronizeSingleGroup(@Parameter(description="The name of the group that should be synchronized.") @PathParam(value="groupName") String groupName, @Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        try {
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            ISynchronizeGroupsStrategy synchronizeGroupsStrategy = toolProvider.createSynchronizeGroupsStrategy(serverName);
            synchronizeGroupsStrategy.synchronizeSingleGroup(groupName);
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

