/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.NotFoundException;
import org.conqat.engine.persistence.store.StorageException;

public abstract class ElementListServiceBase<T>
extends ApiBase {
    protected T getElementWithExistsCheck(String elementName) throws StorageException {
        T element = this.getElement(elementName);
        if (element == null) {
            throw new NotFoundException("Resource for " + elementName + " doesn't exist.");
        }
        return element;
    }

    protected void deleteElementAndPermissions(T elementToDelete) throws StorageException {
        this.deleteElement(elementToDelete);
        this.deletePermissions(elementToDelete);
    }

    protected abstract void deleteElement(T var1) throws StorageException;

    protected abstract void deletePermissions(T var1) throws StorageException;

    protected abstract T getElement(String var1) throws StorageException;

    protected abstract void updateElement(T var1, T var2) throws StorageException;

    protected void createElementAndPermissions(T newElement) throws StorageException {
        this.createElement(newElement);
        this.createPermissions(newElement);
    }

    protected abstract void createElement(T var1) throws StorageException;

    protected abstract void createPermissions(T var1) throws StorageException;
}

