/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commit_trees.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/commit-trees/debug/commit-descriptors")
public class DebugCommitDescriptorDumpService
extends DebugDumpServiceBase {
    private static final String PARENT_LINE_PREFIX = "    ";
    private static final String XDOT_PARAMETER_DESCRIPTION = "If the xdot parameter is true, the service returns commit descriptors as an xdot graph. Otherwise it returns a plain text.";

    @GET
    @Operation(summary="Get commit descriptors", description="Returns commit descriptors for a project.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/plain"})
    public String getDumpCommitDescriptor(@Parameter(description="If the xdot parameter is true, the service returns commit descriptors as an xdot graph. Otherwise it returns a plain text.") @QueryParam(value="xdot") boolean isXdotGraph) throws StorageException {
        this.xdotGraph = isXdotGraph;
        return super.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        List commits = this.openCommitDescriptorIndex().getAllCommits();
        if (this.xdotGraph) {
            DebugCommitDescriptorDumpService.generateXdotGraph(writer, commits);
        } else {
            DebugCommitDescriptorDumpService.dumpCommits(commits, writer);
        }
    }

    public static void dumpCommits(List<ParentedCommitDescriptor> commits, PrintWriter writer) {
        commits.stream().sorted().forEach(commit -> DebugCommitDescriptorDumpService.dumpCommit(commit, writer));
    }

    private static void generateXdotGraph(PrintWriter writer, List<ParentedCommitDescriptor> commits) {
        HashSet edges = new HashSet();
        commits.forEach(node -> DebugCommitDescriptorDumpService.addEdges(edges, node));
        writer.println("digraph {");
        for (String edge : edges) {
            writer.println(edge);
        }
        writer.println("}");
    }

    private static void addEdges(Set<String> edges, ParentedCommitDescriptor commit) {
        for (CommitDescriptor parent : commit.getParentCommits()) {
            edges.add("\"" + String.valueOf(parent) + "\" -> \"" + String.valueOf(commit) + "\"");
        }
    }

    private static void dumpCommit(ParentedCommitDescriptor commit, PrintWriter writer) {
        writer.println(commit);
        commit.getParentCommits().forEach(parent -> writer.println(PARENT_LINE_PREFIX + String.valueOf(parent)));
    }
}

