/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.progress.RevisionAnalysisProgress;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.commits.RepositoryLogIndexUtils;
import com.teamscale.service.commits.RepositoryLogRangeServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/repository-log-range")
public class RepositoryLogRangeService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get repository log entries", description="Retrieves a specific count of repository log entries after a start timestamp or before an end timestamp. If both start and end timestamp are missing, the newest log entries are returned. If both a start and end timestamp are provided all log entries between the two are returned. The resulting log entries include all log entries from merged commits into the current branch. The current branch and branch state at a point in time are determined by the commit parameter.", tags={"Project"})
    public List<ExtendedRepositoryLogEntry> findLogEntriesInRange(@BeanParam RepositoryLogRangeServiceQueryOptions params, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        InternalProjectId internalProjectId = this.serviceInfo.getInternalId();
        ProjectInfo projectInfo = (ProjectInfo)this.openGlobalIndex(ProjectIndex.class).getProjectWithoutPublicIdResolution(internalProjectId).orElseThrow(() -> new NotFoundException("Project not found"));
        if (projectInfo.isDeletingOrReanalyzing()) {
            return Collections.emptyList();
        }
        long startTimestamp = RepositoryLogRangeService.resolveTimestamp(params.getStartTimestampParameter(), params.isIncludeBounds(), true);
        long endTimestamp = RepositoryLogRangeService.resolveTimestamp(params.getEndTimestampParameter(), params.isIncludeBounds(), false);
        CommitDescriptor commit = this.resolve(params.getCommitParameter());
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        LogEntryResolver logEntryResolver = LogEntryResolver.of(this.serviceInfo, userAliasLookup);
        RepositoryLogIndexUtils.RepositoryLogIndexQueryParameters indexQueryParameters = this.generateIndexQueryParameters(userAliasLookup, logEntryResolver, params.getIsPrivacyAware(), repositoryLogFilter, commit);
        return RepositoryLogRangeService.applyIndexQueryParameters(startTimestamp, endTimestamp, params.getEntryCount(), commit, indexQueryParameters);
    }

    private static long resolveTimestamp(long timestampParameter, boolean includeBounds, boolean isStart) {
        long timestamp = -1L;
        if (timestampParameter != Long.MAX_VALUE) {
            timestamp = timestampParameter;
        }
        if (includeBounds && timestamp != -1L) {
            timestamp = isStart ? --timestamp : ++timestamp;
        }
        return timestamp;
    }

    private HashSet<String> getFilteredRevisions() throws StorageException {
        HashSet<String> filteredRevisions = new HashSet<String>();
        for (RevisionAnalysisProgress progress : this.openProjectIndex(ProjectAnalysisProgressIndex.class, null).getProgress()) {
            filteredRevisions.add(Long.toString(progress.commit().getTimestamp()));
        }
        return filteredRevisions;
    }

    private RepositoryLogIndexUtils.RepositoryLogIndexQueryParameters generateIndexQueryParameters(UserAliasLookup userAliasLookup, LogEntryResolver logEntryResolver, boolean privacyAware, RepositoryLogFilter filter, CommitDescriptor commit) throws StorageException {
        filter.setFilteringOptions(this.getFilteredRevisions(), userAliasLookup, commit.getBranchName());
        filter.setPrivacyRelatedFilteringInfo(privacyAware, this.getGlobalStorageSystem(), this.getPermissions(), this.getUser());
        return new RepositoryLogIndexUtils.RepositoryLogIndexQueryParameters(this.openProjectIndex(RepositoryLogIndex.class, null), filter, this.openCommitDescriptorIndex(), logEntryResolver);
    }

    private static List<ExtendedRepositoryLogEntry> applyIndexQueryParameters(long startTimestamp, long endTimestamp, int entryCount, CommitDescriptor commit, RepositoryLogIndexUtils.RepositoryLogIndexQueryParameters queryParameters) throws StorageException {
        if (endTimestamp != -1L && startTimestamp != -1L) {
            return RepositoryLogIndexUtils.obtainEntriesBetween(startTimestamp, endTimestamp, commit, queryParameters);
        }
        if (startTimestamp != -1L) {
            return RepositoryLogIndexUtils.obtainEntriesNewer(entryCount, startTimestamp, commit, queryParameters);
        }
        return RepositoryLogIndexUtils.obtainEntriesOlder(entryCount, endTimestamp, commit, queryParameters);
    }
}

