/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.resource.compare.DiffInputDescription;
import com.teamscale.service.resource.compare.DiffInputLocation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;

public abstract class FindingsIntroductionRemovalServiceBase
extends ApiBase {
    protected TrackedFindingWithDiffInfo createFindingWithDiffInfo(TrackedFinding finding) throws StorageException {
        return new TrackedFindingWithDiffInfo(finding, this.determineCreationInfo(finding), this.determineRemovalInfo(finding));
    }

    private Pair<DiffInputDescription, Boolean> determineCreationInfo(TrackedFinding finding) throws StorageException {
        CommitDescriptor birthCommit = finding.getBirthCommit();
        HistoryAccessOption birthHistoryAccess = HistoryAccessOption.readTimestamp((String)birthCommit.getBranchName(), (long)birthCommit.getTimestamp());
        TrackedFinding initialFinding = this.openProjectIndex(TrackedFindingsByIdIndex.class, birthHistoryAccess).getFinding(finding.getId());
        CCSMAssert.isNotNull((Object)initialFinding, (String)("No corresponding initial finding found at birth commit " + String.valueOf(birthCommit) + " for finding " + String.valueOf(finding)));
        ElementHistoryIndex historyIndex = this.openProjectIndex(ElementHistoryIndex.class, birthHistoryAccess);
        ElementHistoryEntry creationHistoryEntry = historyIndex.getHistoryEntry(initialFinding.getLocation().getUniformPath());
        CCSMAssert.isNotNull((Object)creationHistoryEntry);
        return this.determineCreationInfo(initialFinding, birthCommit, creationHistoryEntry);
    }

    private Pair<DiffInputDescription, Boolean> determineCreationInfo(TrackedFinding initialFinding, CommitDescriptor birthCommit, ElementHistoryEntry creationHistoryEntry) throws StorageException {
        if (creationHistoryEntry.getTimestamp() < birthCommit.getTimestamp()) {
            return new Pair(null, (Object)true);
        }
        if (creationHistoryEntry.getChangeType() == EElementHistoryChangeType.ADD || creationHistoryEntry.getChangeType() == EElementHistoryChangeType.COPY) {
            return FindingsIntroductionRemovalServiceBase.noDiff();
        }
        DiffInputLocation leftLocation = creationHistoryEntry.getChangeType() == EElementHistoryChangeType.MOVE ? new DiffInputLocation(creationHistoryEntry.getOriginPath(), creationHistoryEntry.getOriginCommit()) : new DiffInputLocation(initialFinding.getLocation().getUniformPath(), this.resolveParent(birthCommit));
        Integer line = null;
        if (initialFinding.getLocation() instanceof TextRegionLocation) {
            line = ((TextRegionLocation)initialFinding.getLocation()).getRawStartLine();
        }
        DiffInputLocation rightLocation = new DiffInputLocation(initialFinding.getLocation().getUniformPath(), birthCommit, line);
        return new Pair((Object)new DiffInputDescription(leftLocation, rightLocation), (Object)false);
    }

    private static Pair<DiffInputDescription, Boolean> noDiff() {
        return new Pair(null, (Object)false);
    }

    private Pair<DiffInputDescription, Boolean> determineRemovalInfo(TrackedFinding finding) throws StorageException {
        if (finding.isAlive()) {
            return FindingsIntroductionRemovalServiceBase.noDiff();
        }
        CommitDescriptor deathCommit = finding.getDeathCommit();
        ElementHistoryIndex historyIndex = this.openProjectIndex(ElementHistoryIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)deathCommit));
        ElementHistoryEntry removalHistoryEntry = historyIndex.getHistoryEntry(finding.getLocation().getUniformPath());
        CCSMAssert.isNotNull((Object)removalHistoryEntry);
        return this.determineRemovalInfo(finding, deathCommit, removalHistoryEntry, historyIndex);
    }

    private Pair<DiffInputDescription, Boolean> determineRemovalInfo(TrackedFinding finding, CommitDescriptor deathCommit, ElementHistoryEntry removalHistoryEntry, ElementHistoryIndex historyIndex) throws StorageException {
        if (removalHistoryEntry.getTimestamp() < deathCommit.getTimestamp()) {
            return new Pair(null, (Object)true);
        }
        Integer line = null;
        if (finding.getLocation() instanceof TextRegionLocation) {
            line = ((TextRegionLocation)finding.getLocation()).getRawStartLine();
        }
        DiffInputLocation leftLocation = new DiffInputLocation(finding.getLocation().getUniformPath(), this.resolveParent(deathCommit), line);
        if (removalHistoryEntry.getChangeType() == EElementHistoryChangeType.EDIT) {
            return new Pair((Object)new DiffInputDescription(leftLocation, new DiffInputLocation(finding.getLocation().getUniformPath(), deathCommit)), (Object)false);
        }
        DiffInputLocation renameTarget = this.findRenameTarget(finding, deathCommit, historyIndex);
        if (renameTarget != null) {
            return new Pair((Object)new DiffInputDescription(leftLocation, renameTarget), (Object)false);
        }
        return FindingsIntroductionRemovalServiceBase.noDiff();
    }

    private DiffInputLocation findRenameTarget(TrackedFinding finding, CommitDescriptor deathCommit, ElementHistoryIndex historyIndex) throws StorageException {
        RepositoryLogFileIndex logFileIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        List files = logFileIndex.getEntriesByCommit(deathCommit);
        ArrayList<String> candidatePaths = new ArrayList<String>();
        for (RepositoryLogFileEntry file : files) {
            if (file.isDeleted()) continue;
            candidatePaths.add(file.getUniformPath().toStringAsMigrationFrontier());
        }
        if (candidatePaths.isEmpty()) {
            return null;
        }
        List historyEntries = historyIndex.getHistoryEntries(candidatePaths);
        for (int i = 0; i < historyEntries.size(); ++i) {
            ElementHistoryEntry entry = (ElementHistoryEntry)historyEntries.get(i);
            if (entry == null || !finding.getLocation().getUniformPath().equals(entry.getOriginPath())) continue;
            return new DiffInputLocation((String)candidatePaths.get(i), deathCommit);
        }
        return null;
    }

    @NoIndexValueClass(rationale="Only used for enhancing the TrackedFinding with some more information in the REST layer.")
    public static class TrackedFindingWithDiffInfo
    extends TrackedFinding {
        private static final long serialVersionUID = 1L;
        private final transient @Nullable DiffInputDescription creationDiff;
        @JsonProperty(value="createdByOtherChange")
        private final boolean createdByOtherChange;
        private final transient @Nullable DiffInputDescription removalDiff;
        @JsonProperty(value="removedByOtherChange")
        private final boolean removedByOtherChange;

        public TrackedFindingWithDiffInfo(TrackedFinding trackedFinding, Pair<DiffInputDescription, Boolean> creationInfo, Pair<DiffInputDescription, Boolean> removalInfo) {
            super(trackedFinding);
            this.creationDiff = (DiffInputDescription)creationInfo.getFirst();
            this.createdByOtherChange = (Boolean)creationInfo.getSecond();
            this.removalDiff = (DiffInputDescription)removalInfo.getFirst();
            this.removedByOtherChange = (Boolean)removalInfo.getSecond();
        }

        @JsonGetter(value="creationDiff")
        public @Nullable DiffInputDescription getCreationDiff() {
            return this.creationDiff;
        }

        public boolean isCreatedByOtherChange() {
            return this.createdByOtherChange;
        }

        @JsonGetter(value="removalDiff")
        public @Nullable DiffInputDescription getRemovalDiff() {
            return this.removalDiff;
        }

        public boolean isRemovedByOtherChange() {
            return this.removedByOtherChange;
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        public int hashCode() {
            return super.hashCode();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            SerializationUtils.unsupportedWriteObject((ObjectOutputStream)stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            SerializationUtils.unsupportedReadObject((ObjectInputStream)stream);
        }
    }
}

