/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.badge;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.service.findings.FindingChurnByIssueServiceBase;
import com.teamscale.service.findings.badge.FindingBadgeCreator;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/issues/{issueId}/findings-badge")
public class IssueFindingBadgeService
extends FindingChurnByIssueServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Badge
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get issue finding badge", description="Creates a finding badge for the given issue.", tags={"Issues", "Findings", "Badge"}, responses={@ApiResponse(responseCode="404", description="Issue with provided ID could not be found.", content={@Content(mediaType="image/svg+xml", schema=@Schema(description="Error badge with message.", implementation=String.class))}), @ApiResponse(responseCode="409", description="Multiple issues for the provided ID found", content={@Content(mediaType="image/svg+xml", schema=@Schema(description="Error badge with message.", implementation=String.class))})})
    @Produces(value={"image/svg+xml"})
    public byte[] getIssueFindingBadge(@Parameter(description="ID of the issue to create a finding badge for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId) throws StorageException {
        FindingChurnList findingChurn = this.getFindingChurn(issueId, true, JiraConnectorUtils.shouldHideResolveFindingsInBadges((ProjectStorageSystem)this.getProjectStorageSystem(), (Logger)LOGGER));
        return IssueFindingBadgeService.createBadge(findingChurn);
    }

    private static byte[] createBadge(FindingChurnList issueFindingChurn) {
        FindingDeltaCount delta = FindingDeltaCount.create((FindingChurnList)issueFindingChurn);
        return StringUtils.stringToBytes((String)new FindingBadgeCreator(delta, true).createBadge());
    }
}

