/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.simulink.debug;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.tracking.algorithm.EFindingIdentificationCriterion;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.index.FindingIdentificationIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.repository.ProjectBranchesService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/simulink/debug/repair-simulink-finding-identification")
public class SimulinkFindingIdentificationRepairService
extends ApiBase {
    private static final String DESCRIPTION = "Repairs unprecise finding identification entries for Simulink findings. This should only be used for cases where Simulink finding tolerations or false positives are missing.";

    @GET
    @Operation(summary="Repairs the finding identification for Simulink findings.", description="Repairs unprecise finding identification entries for Simulink findings. This should only be used for cases where Simulink finding tolerations or false positives are missing.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response repairSimulinkFindingIdentification() throws ConQATException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        int numberOfNewOrChangedEntries = 0;
        for (InternalProjectId projectId : projectIndex.getAllInternalProjectIds()) {
            CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem((IProjectId)projectId);
            FindingIdentificationIndex findingIdentificationIndex = (FindingIdentificationIndex)projectStorageSystem.openProjectIndex(FindingIdentificationIndex.class, null);
            SetMap<ByteArrayWrapper, ByteArrayWrapper> keysAndFindingIds = this.computeCriterionKeysAndFindingsForAllBranches(projectStorageSystem);
            numberOfNewOrChangedEntries += findingIdentificationIndex.mergeCharacteristics(keysAndFindingIds);
        }
        if (numberOfNewOrChangedEntries == 0) {
            return LegacyApiUtils.plainText((String)"Success! No entries in FindingIdentificationIndex had to be changed.");
        }
        return LegacyApiUtils.plainText((String)String.format("Successfully added or changed %d entries in the FindingIndentificationIndex", numberOfNewOrChangedEntries));
    }

    private @NonNull SetMap<ByteArrayWrapper, ByteArrayWrapper> computeCriterionKeysAndFindingsForAllBranches(CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        SetMap keysAndFindingIds = new SetMap();
        for (String branch : this.getAllBranches(projectStorageSystem)) {
            for (TrackedFinding finding : SimulinkFindingIdentificationRepairService.getQualifiedNameFindings(branch, projectStorageSystem)) {
                byte[] binaryFindingId = StringUtils.decodeFromHex((String)finding.getId());
                for (EFindingIdentificationCriterion criterion : EFindingIdentificationCriterion.values()) {
                    TrackedElement element = new TrackedElement(finding.getLocation().getUniformPath(), Collections.emptyList());
                    criterion.calculateCriterion((IndexFinding)finding, element).ifPresent(value -> keysAndFindingIds.add((Object)new ByteArrayWrapper(FindingIdentificationIndex.createKey((EFindingIdentificationCriterion)criterion, (String)value)), (Object)new ByteArrayWrapper(binaryFindingId)));
                }
            }
        }
        return keysAndFindingIds;
    }

    private static @NonNull List<TrackedFinding> getQualifiedNameFindings(String branch, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)branch);
        TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        return findingsIndex.getAllEntries().stream().map(ImmutablePair::getSecond).flatMap(Collection::stream).filter(finding -> finding.getLocation() instanceof QualifiedNameLocation).toList();
    }

    private @NonNull Set<String> getAllBranches(CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)projectStorageSystem.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        return ProjectBranchesService.getLiveBranches(this.getPermissions(), repositoryStatus, "noname");
    }
}

