/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.testgap.TeamscaleIssueWithTgaInfo;
import com.teamscale.wia.TeamscaleIssue;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class IssueFilterUtils {
    public static final String QUERY_PARAMETER = "query";
    public static final String TGA_FILTER_PARAMETER = "tga-filter";
    public static final String CHANGED_METHODS_COUNT = "changed-methods-count";
    public static final String TEST_GAP_RATIO = "test-gap-ratio";
    public static final String NUMBER_OF_TEST_GAPS = "number-of-test-gaps";

    public static <T extends TeamscaleIssue> List<T> applyFiltersAndPagination(List<T> issues, SortAndPaginationOptions parameters, IKeyedObjectDescriber<? super T> describer) {
        Function comparatorProvider = sortBy -> {
            Comparator comparator = IssueFilterUtils.getComparatorForField(sortBy);
            if (comparator == null) {
                Comparator tmp;
                comparator = tmp = describer.getValueComparator(sortBy);
            }
            return comparator;
        };
        return parameters.sortAndPaginate(issues, comparatorProvider);
    }

    private static <T extends TeamscaleIssue> Comparator<T> getComparatorForField(String sortBy) {
        if (CHANGED_METHODS_COUNT.equalsIgnoreCase(sortBy)) {
            return Comparator.comparingInt(issue -> ((TeamscaleIssueWithTgaInfo)((Object)issue)).getTgaSummary().getTotalStates()).thenComparing(TeamscaleIssue::getId);
        }
        if (TEST_GAP_RATIO.equalsIgnoreCase(sortBy)) {
            return Comparator.comparing(issue -> ((TeamscaleIssueWithTgaInfo)((Object)issue)).getTgaSummary()).thenComparing(issue -> ((TeamscaleIssueWithTgaInfo)((Object)issue)).getTgaSummary().getNumberOfTestGaps()).thenComparing(TeamscaleIssue::getId);
        }
        if (NUMBER_OF_TEST_GAPS.equalsIgnoreCase(sortBy)) {
            return Comparator.comparingInt(issue -> ((TeamscaleIssueWithTgaInfo)((Object)issue)).getTgaSummary().getNumberOfTestGaps()).thenComparing(TeamscaleIssue::getId);
        }
        return null;
    }

    private IssueFilterUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

