/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.issues.model.UserResolvedTeamscaleIssue;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.EIssueTgaFilterOption;
import com.teamscale.service.issues.IssueFilterUtils;
import com.teamscale.service.issues.IssuesExportRequestOption;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.issues.TeamscaleUserAliasResolver;
import com.teamscale.service.testgap.TeamscaleIssueWithTgaInfo;
import com.teamscale.service.testgap.TgaSummary;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;

@Path(value="api/projects/{project}/issue-query/with-tga")
public class TgaIssueQueryService
extends QueryServiceBase {
    private static final Set<String> TGA_SORT_FIELDS = Set.of("changed-methods-count", "test-gap-ratio", "number-of-test-gaps");

    @GET
    @Operation(summary="Perform issue query with TGA-related data", description="Retrieves the size and list of issues for the query.", tags={"Issues", "Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryServiceBase.QueryParserFailure.class))}, description="Could not process query.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public QueryServiceBase.IssueQueryResult<UserResolvedTeamscaleIssue> performIssueTgaQuery(@Parameter(description="Issue query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @Parameter(description="TGA filter") @QueryParam(value="tga-filter") EIssueTgaFilterOption tgaFilter, @BeanParam SortAndPaginationOptions parameters, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException {
        List<TeamscaleIssueWithTgaInfo> issuesWithTga;
        String branch = TgaIssueRequest.determineIssueBranch((IssueTgaParameters)issueTgaParameters, null, (CommitResolvingStorageSystem)this.getProjectStorageSystem());
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)branch);
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        List<TeamscaleIssue> issues = this.performIssueQuery(query, (IKeyedObjectIndex<TeamscaleIssue>)indexAggregation, historyAccessOption);
        int actualResultSize = issues.size();
        if (TgaIssueQueryService.needsTgaSummaryForAllIssues(tgaFilter, parameters)) {
            issuesWithTga = this.augmentWithTgaData(issues, issueTgaParameters, coverageSourceParameters, assessmentOptions);
            List<TeamscaleIssueWithTgaInfo> issuesAfterTgaFilter = TgaIssueQueryService.applyTgaFilter(issuesWithTga, tgaFilter);
            actualResultSize = issuesAfterTgaFilter.size();
            issuesWithTga = IssueFilterUtils.applyFiltersAndPagination(issuesAfterTgaFilter, parameters, indexAggregation.getDescriber());
        } else {
            List<TeamscaleIssue> issuesAfterFilterAndPagination = IssueFilterUtils.applyFiltersAndPagination(issues, parameters, indexAggregation.getDescriber());
            issuesWithTga = this.augmentWithTgaData(issuesAfterFilterAndPagination, issueTgaParameters, coverageSourceParameters, assessmentOptions);
        }
        TeamscaleUserAliasResolver resolver = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        List userResolvedIssues = UserResolvedTeamscaleIssue.of(issuesWithTga, resolver.resolveIssues(issuesWithTga));
        return QueryServiceBase.IssueQueryResult.of(actualResultSize, userResolvedIssues, parameters.getNextStartIndex());
    }

    private static boolean needsTgaSummaryForAllIssues(EIssueTgaFilterOption tgaFilter, SortAndPaginationOptions parameters) {
        boolean sortAndPaginateOptionsAvailable = parameters != null && parameters.getSortOptions() != null && parameters.getSortOptions().getSortBy() != null;
        boolean tgaFilterActive = EIssueTgaFilterOption.ONLY_WITH_CHANGES == tgaFilter || EIssueTgaFilterOption.ONLY_WITH_TEST_GAPS == tgaFilter;
        return sortAndPaginateOptionsAvailable && TGA_SORT_FIELDS.contains(parameters.getSortOptions().getSortBy()) || tgaFilterActive;
    }

    private List<TeamscaleIssueWithTgaInfo> augmentWithTgaData(List<TeamscaleIssue> issues, IssueTgaParameters issueTgaParameters, CoverageSourceQueryParameters coverageSourceQueryParameters, TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException {
        List issueIds = issues.stream().map(TeamscaleIssue::getId).collect(Collectors.toList());
        RepositoryCommitIssueMappingIndexCache mappingIndexCache = TgaRequestUtils.createAndPreloadIssueMappingCache(issueIds, (CommitResolvingStorageSystem)this.serviceInfo.getProjectStorageSystem());
        IndexLayer indexLayer = this.serviceInfo.getIndexLayer();
        PublicProjectId projectId = this.serviceInfo.getPrimaryPublicId();
        return issues.parallelStream().map(issue -> TgaIssueQueryService.augmentWithTgaData(issueTgaParameters, coverageSourceQueryParameters, assessmentOptions.getAssessmentType(), mappingIndexCache, issue, indexLayer, (IProjectId)projectId)).collect(Collectors.toList());
    }

    private static @NonNull TeamscaleIssueWithTgaInfo augmentWithTgaData(IssueTgaParameters issueTgaParameters, CoverageSourceQueryParameters coverageSourceQueryParameters, ETgaAssessmentType assessmentType, RepositoryCommitIssueMappingIndexCache mappingIndexCache, TeamscaleIssue issue, IndexLayer indexLayer, IProjectId projectId) {
        try {
            if (mappingIndexCache.getValue(issue.getId()) == null) {
                TgaSummary tgaSummary = new TgaSummary(assessmentType, (CounterSet<ETestGapState>)new CounterSet());
                return new TeamscaleIssueWithTgaInfo(issue, tgaSummary);
            }
            TgaIssueRequest request = TgaIssueRequest.createRequest((TeamscaleIssueId)issue.getId(), (CoverageSourceParameterBase)coverageSourceQueryParameters, (IssueTgaParameters)issueTgaParameters, (ETgaAssessmentType)assessmentType, (RepositoryCommitIssueMappingIndexCache)mappingIndexCache, (IndexLayer)indexLayer, (IProjectId)projectId);
            AssessedTgaData assessedData = request.fetchAndAssessData();
            CounterSet states = TgaAggregationUtils.countStates((AssessedTgaData)assessedData);
            TgaSummary tgaSummary = new TgaSummary(assessmentType, (CounterSet<ETestGapState>)states);
            return new TeamscaleIssueWithTgaInfo(issue, tgaSummary);
        }
        catch (StorageException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private static List<TeamscaleIssueWithTgaInfo> applyTgaFilter(List<TeamscaleIssueWithTgaInfo> issuesWithTga, EIssueTgaFilterOption tgaFilter) {
        return CollectionUtils.filter(issuesWithTga, issue -> !TgaIssueQueryService.isFilteredOut(tgaFilter, issue.getTgaSummary()));
    }

    private static boolean isFilteredOut(EIssueTgaFilterOption tgaFilter, TgaSummary tgaSummary) {
        boolean isIssueWithoutChanges = tgaSummary.getTotalStates() == 0;
        boolean isIssueWithoutTestGaps = tgaSummary.getTestGapRatio() == 0.0;
        return EIssueTgaFilterOption.ONLY_WITH_CHANGES == tgaFilter && isIssueWithoutChanges || EIssueTgaFilterOption.ONLY_WITH_TEST_GAPS == tgaFilter && isIssueWithoutTestGaps;
    }

    @GET
    @Path(value="export/{format}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export issues", description="Export issues for the element with the provided uniform path in the given format.", tags={"Issues", "Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="The query is invalid.")})
    public Response getIssuesExport(@BeanParam IssuesExportRequestOption requestOption) throws StorageException {
        List<TeamscaleIssueWithTgaInfo> issues = this.performIssueQueryWithTga(requestOption.getIssueQuery(), requestOption.getTgaFilter(), requestOption.getParameters(), requestOption.getTgaParameters(), requestOption.getCoverageSourceQueryParameters(), requestOption.getAssessmentOptions());
        return requestOption.getExportFormat().createIssuesExportDownload(issues, this.serviceInfo.getPrimaryPublicId());
    }

    private List<TeamscaleIssueWithTgaInfo> performIssueQueryWithTga(String query, EIssueTgaFilterOption tgaFilter, SortAndPaginationOptions parameters, IssueTgaParameters issueTgaParameters, CoverageSourceQueryParameters coverageSourceQueryParameters, TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)TgaIssueRequest.determineIssueBranch((IssueTgaParameters)issueTgaParameters, null, (CommitResolvingStorageSystem)this.getProjectStorageSystem()));
        WorkItemHistoryIndexAggregation issueHistoryAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        List<TeamscaleIssue> issues = this.performIssueQuery(query, (IKeyedObjectIndex<TeamscaleIssue>)issueHistoryAggregation, historyAccessOption);
        List<TeamscaleIssueWithTgaInfo> issuesWithTga = this.augmentWithTgaData(issues, issueTgaParameters, coverageSourceQueryParameters, assessmentOptions);
        List<TeamscaleIssueWithTgaInfo> issueWithTgaInfos = TgaIssueQueryService.applyTgaFilter(issuesWithTga, tgaFilter);
        return IssueFilterUtils.applyFiltersAndPagination(issueWithTgaInfos, parameters, issueHistoryAggregation.getDescriber());
    }
}

