/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.force_vote.strategy;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.merge_request.EMergeRequestUpdateTriggerSchedulingReason;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.github.GitHubMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestUpdateTrigger;
import com.teamscale.service.merge_request.force_vote.strategy.IMergeRequestForceVoteStrategy;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitMergeRequestVoteStrategy
implements IMergeRequestForceVoteStrategy {
    private final InternalProjectId projectId;
    private final MergeRequestIndex mergeRequestIndex;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final IndexLayer indexLayer;
    private final Logger logger;

    public GitMergeRequestVoteStrategy(InternalProjectId projectId, MergeRequestIndex mergeRequestIndex, CommitDescriptorIndex commitDescriptorIndex, IndexLayer indexLayer, Logger logger) {
        this.projectId = projectId;
        this.mergeRequestIndex = mergeRequestIndex;
        this.commitDescriptorIndex = commitDescriptorIndex;
        this.indexLayer = indexLayer;
        this.logger = logger;
    }

    @Override
    public void forceVoteOnMergeRequests(List<MergeRequest> mergeRequests, ConnectorConfiguration connectorConfiguration) throws StorageException {
        String repositoryName = connectorConfiguration.getOptionValue("Repository name");
        List connectorMergeRequests = CollectionUtils.filter(mergeRequests, mr -> mr.identifier.repositoryName.equalsIgnoreCase(repositoryName));
        this.mergeRequestIndex.addVotingRelevantChangeTimestamp(connectorMergeRequests);
        this.forceVoteOnMergeRequestsInternal(connectorMergeRequests, connectorConfiguration);
    }

    private void forceVoteOnMergeRequestsInternal(List<MergeRequest> mergeRequests, ConnectorConfiguration connectorConfiguration) throws StorageException {
        ERepositoryConnector connectorType = ERepositoryConnector.findByReadableName((String)connectorConfiguration.getType());
        for (MergeRequest mergeRequest : mergeRequests) {
            @Nullable String extraParam = GitMergeRequestVoteStrategy.getExtraJobParameter(connectorConfiguration, connectorType);
            MergeRequestUpdateTriggerBase.JobParameter parameter = new MergeRequestUpdateTriggerBase.JobParameter(mergeRequest.identifier, true, extraParam);
            CommitDescriptor schedulingCommit = this.commitDescriptorIndex.getLatestCommitForBranch(mergeRequest.sourceBranch).orElse(null);
            JobDescriptor job = new JobDescriptor(this.projectId, GitMergeRequestVoteStrategy.getTriggerClass(connectorType), schedulingCommit, (Object)parameter, EMergeRequestUpdateTriggerSchedulingReason.FORCE_VOTE.format(mergeRequest.identifier.id));
            try {
                ISchedulerCommunicator.getInstance().scheduleExternalJob(this.indexLayer, job);
            }
            catch (StorageException e) {
                this.logger.atError().withThrowable((Throwable)e).log("Failed to re-vote on merge request {} in repository {}", (Object)mergeRequest.identifier.id, (Object)mergeRequest.identifier.repositoryName);
            }
        }
    }

    private static String getExtraJobParameter(ConnectorConfiguration connectorConfiguration, ERepositoryConnector connectorType) {
        if (connectorType == ERepositoryConnector.GITHUB) {
            return connectorConfiguration.getOptionValue("GitHub Server URL");
        }
        return null;
    }

    private static Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>> getTriggerClass(ERepositoryConnector connectorType) {
        return switch (connectorType) {
            case ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST -> ArtificialMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.AZURE_DEVOPS_GIT -> AzureDevOpsGitMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.BITBUCKET -> BitbucketCloudMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.BITBUCKET_SERVER -> BitbucketServerMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.GITEA -> GiteaMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.GITHUB -> GitHubMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.GITLAB -> GitLabMergeRequestUpdateTrigger.class;
            case ERepositoryConnector.SCM_MANAGER -> ScmManagerMergeRequestUpdateTrigger.class;
            default -> throw new IllegalArgumentException("Unsupported connector type. It must be one of [AZURE_DEVOPS_GIT, BITBUCKET, BITBUCKET_SERVER, GITEA, GITHUB, GITLAB, SCM_MANAGER]");
        };
    }
}

