/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.metrics.assessment.context.PartitionUpdateType;
import com.teamscale.service.merge_request.metrics.DeltaEntry;
import com.teamscale.service.merge_request.metrics.EChangeType;
import com.teamscale.service.merge_request.metrics.EMetricTrendColor;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsBinarySizeUtils;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsUtils;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaParams;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaTreemapNode;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class SingleMetricDeltaTreemapBuilder
extends MetricTreemapBuilderBase<SingleMetricDeltaTreemapNode> {
    private final UnmodifiableMap<String, DeltaEntry> deltasByUniformPath;
    private final double maxDelta;
    private final boolean filterUnchangedEntries;
    private final boolean showDeletedEntries;
    private final HistoryAccessOption rangeStart;
    private final PartitionUpdateType partitionUpdateType;
    private final EColoringStrategy coloringStrategy;

    public SingleMetricDeltaTreemapBuilder(SingleMetricDeltaParams params) throws StorageException {
        super(params.metricRetrievalStrategy(), HistoryAccessOption.readCommit((CommitDescriptor)params.timeRange().end()), params.metricIndex(), new MetricTreemapBuilderParameters(null, null, params.metricIndex(), 0.0, EMetricTrendColor.UNCHANGED_TREEMAP.getColor(params.isColorBlindModeEnabled()), params.isColorBlindModeEnabled()));
        this.partitionUpdateType = params.partitionUpdateType();
        this.filterUnchangedEntries = params.isFilteredUnchangedEntries();
        this.showDeletedEntries = params.isShowDeletedEntries();
        this.coloringStrategy = params.isCalculateEntryBasedDeltaPercentage() ? EColoringStrategy.ENTRY_DELTA : EColoringStrategy.GLOBAL_MAX_DELTA;
        this.rangeStart = HistoryAccessOption.readCommit((CommitDescriptor)params.timeRange().start());
        MetricDirectorySchema schema = (MetricDirectorySchema)this.metricDirectorySchemaSupplier.get();
        List<MetricDirectoryEntry> startEntries = this.getEntriesFor(params.uniformPath(), this.rangeStart);
        List<MetricDirectoryEntry> endEntries = this.getEntriesFor(params.uniformPath(), HistoryAccessOption.readCommit((CommitDescriptor)params.timeRange().end()));
        if (this.partitionUpdateType == PartitionUpdateType.BRANCH_HEAD_OUTDATED || this.partitionUpdateType == PartitionUpdateType.NO_UPDATES) {
            startEntries = new ArrayList<MetricDirectoryEntry>();
            endEntries = new ArrayList<MetricDirectoryEntry>();
        } else if (this.partitionUpdateType == PartitionUpdateType.BASELINE_INCOMPLETE) {
            startEntries = new ArrayList<MetricDirectoryEntry>();
        }
        Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startNonCodeContents = MergeRequestSingleMetricDetailsBinarySizeUtils.getNonCodeLinkContent(startEntries, params.startBasicContentIndex());
        Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endNonCodeContents = MergeRequestSingleMetricDetailsBinarySizeUtils.getNonCodeLinkContent(endEntries, params.endBasicContentIndex());
        this.deltasByUniformPath = MergeRequestSingleMetricDetailsUtils.computeDeltasByUniformPath(startEntries, endEntries, startNonCodeContents, endNonCodeContents, params.metricIndex(), schema, params.isHideRefactoredEntries(), true, this.showDeletedEntries, this.partitionUpdateType);
        this.maxDelta = SingleMetricDeltaTreemapBuilder.computeMaxDelta(this.deltasByUniformPath, MergeRequestSingleMetricDetailsUtils.getLeafPaths(startEntries, endEntries)).orElse(0.0);
    }

    @Override
    protected List<MetricDirectoryEntry> getEntriesFor(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        Map uniformPathToMetricDirectoryEntry = super.getEntriesFor(uniformPath).stream().collect(Collectors.toMap(MetricDirectoryEntry::getUniformPath, Function.identity()));
        if (this.showDeletedEntries) {
            super.getEntriesFor(uniformPath, this.rangeStart).stream().filter(entry -> this.deltasByUniformPath.containsKey((Object)entry.getUniformPath())).filter(entry -> ((DeltaEntry)this.deltasByUniformPath.get((Object)entry.getUniformPath())).change() == EChangeType.DELETE).forEach(entry -> uniformPathToMetricDirectoryEntry.put(entry.getUniformPath(), entry));
        }
        return new ArrayList<MetricDirectoryEntry>(uniformPathToMetricDirectoryEntry.values());
    }

    @Override
    public @Nullable SingleMetricDeltaTreemapNode buildTreeMap(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        if (this.partitionUpdateType == PartitionUpdateType.BRANCH_HEAD_OUTDATED || this.partitionUpdateType == PartitionUpdateType.NO_UPDATES) {
            return null;
        }
        return (SingleMetricDeltaTreemapNode)((Object)super.buildTreeMap(uniformPath));
    }

    private Color blendTrendColor(Color trendColor, Color baseColor, DeltaEntry delta) {
        if (MergeRequestSingleMetricDetailsUtils.isZero(delta.delta())) {
            return baseColor;
        }
        double reference = switch (this.coloringStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> delta.startValue();
            case 0 -> this.maxDelta;
        };
        double lowerBound = 0.025;
        double factor = lowerBound + Math.min(Math.abs(delta.delta() / reference), 1.0) * (1.0 - lowerBound);
        if (factor > 1.0) {
            factor = 1.0;
        }
        return ColorUtils.blend((double)factor, (Color)trendColor, (Color)baseColor);
    }

    private static Optional<Double> computeMaxDelta(UnmodifiableMap<String, DeltaEntry> deltasByUniformPath, Set<String> leafPaths) {
        return deltasByUniformPath.entrySet().stream().filter(entry -> leafPaths.contains(entry.getKey())).map(Map.Entry::getValue).map(DeltaEntry::delta).map(Math::abs).reduce(Double::max);
    }

    @Override
    protected List<MetricDirectoryEntry> filterEntries(List<MetricDirectoryEntry> entries, String rootPath) {
        if (this.filterUnchangedEntries) {
            return this.removeUnchangedEntries(entries);
        }
        return super.filterEntries(entries, rootPath);
    }

    private @NonNull List<MetricDirectoryEntry> removeUnchangedEntries(List<MetricDirectoryEntry> entries) {
        Map entriesByPath = entries.stream().collect(Collectors.toMap(MetricDirectoryEntry::getUniformPath, Function.identity()));
        HashSet<MetricDirectoryEntry> result = new HashSet<MetricDirectoryEntry>();
        for (MetricDirectoryEntry entry : entries) {
            if (entry.hasChildren() || !this.deltasByUniformPath.containsKey((Object)entry.getUniformPath())) continue;
            result.add(entry);
            String parentPath = entry.getUniformPath();
            while (!parentPath.isEmpty() && result.add((MetricDirectoryEntry)entriesByPath.get(parentPath = UniformPathUtils.getParentPath((String)parentPath)))) {
            }
        }
        return CollectionUtils.filter(entries, result::contains);
    }

    @Override
    protected SingleMetricDeltaTreemapNode buildTreeMapNodes(List<MetricDirectoryEntry> entries) throws StorageException, TreeMapBuilderException {
        SingleMetricDeltaTreemapNode root = (SingleMetricDeltaTreemapNode)((Object)super.buildTreeMapNodes(entries));
        root.recalculateAreaAggregates();
        return root;
    }

    @Override
    protected SingleMetricDeltaTreemapNode createNode(MetricDirectoryEntry entry) throws StorageException, TreeMapBuilderException {
        MetricDirectorySchema schema = (MetricDirectorySchema)this.metricDirectorySchemaSupplier.get();
        Optional<DeltaEntry> deltaEntry = Optional.ofNullable((DeltaEntry)this.deltasByUniformPath.get((Object)entry.getUniformPath()));
        return new SingleMetricDeltaTreemapNode(entry.getUniformPath(), MergeRequestSingleMetricDetailsUtils.getAsDouble(entry, this.areaMetricIndex, schema), deltaEntry.map(DeltaEntry::delta).orElseGet(() -> MergeRequestSingleMetricDetailsUtils.getDefaultValue(schema, this.areaMetricIndex)).toString(), this.determineColor(entry), deltaEntry.map(DeltaEntry::change).orElse(EChangeType.UNCHANGED));
    }

    @Override
    protected @Nullable Color determineColor(MetricDirectoryEntry entry) throws StorageException {
        if (entry.hasChildren()) {
            return this.builderParameters.baseColor;
        }
        if (!this.deltasByUniformPath.containsKey((Object)entry.getUniformPath())) {
            return this.builderParameters.baseColor;
        }
        DeltaEntry delta = (DeltaEntry)this.deltasByUniformPath.get((Object)entry.getUniformPath());
        if (delta == null) {
            return this.builderParameters.baseColor;
        }
        MetricDirectorySchema schema = (MetricDirectorySchema)this.metricDirectorySchemaSupplier.get();
        Set properties = schema.getEntry(this.areaMetricIndex).getProperties();
        if (properties.contains(EMetricProperty.QUALITY_NEUTRAL)) {
            return this.blendTrendColor(EMetricTrendColor.NEUTRAL_TREEMAP.getColor(this.builderParameters.isColorBlindModeEnabled()), this.builderParameters.baseColor, delta);
        }
        EMetricTrendColor trendColor = MergeRequestSingleMetricDetailsUtils.determineTrendColor(delta, schema, this.areaMetricIndex);
        if (trendColor == null) {
            return this.builderParameters.baseColor;
        }
        return this.blendTrendColor(trendColor.getColor(this.builderParameters.isColorBlindModeEnabled()), this.builderParameters.baseColor, delta);
    }

    private static enum EColoringStrategy {
        GLOBAL_MAX_DELTA,
        ENTRY_DELTA;

    }
}

