/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/branch-analysis-state")
public class BranchAnalysisStateService
extends ApiBase {
    @GET
    @Path(value="{branchName: .*}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns branch or project analysis state", description="Provides the most up-to-date information about completed and currently-analyzed projects and branches. The analysis state is obtained from the branch, if it is given as target. Otherwise the analysis state is based on the project's default branch.", tags={"Project", "Monitoring"})
    public AnalysisState getAnalysisState(@PathParam(value="branchName") String branchName) throws StorageException {
        BranchAnalysisStateIndex branchAnalysisStateIndex;
        AnalysisState analysisState;
        if (StringUtils.isEmpty((String)branchName)) {
            branchName = this.getDefaultBranchName();
        }
        if ((analysisState = (branchAnalysisStateIndex = this.openProjectIndex(BranchAnalysisStateIndex.class, null)).getAnalysisState(branchName)) == null) {
            if (EAnalysisState.LIVE_ANALYSIS == ((ProjectAnalysisProgressIndex)this.getProjectStorageSystem().openProjectIndex(ProjectAnalysisProgressIndex.class, null)).getAnalysisState()) {
                long timestamp = 0L;
                if (this.isDefaultBranchWithNoRepositoryConnectors(branchName)) {
                    timestamp = 1L;
                }
                analysisState = new AnalysisState(Long.valueOf(timestamp), EAnalysisState.LIVE_ANALYSIS, null);
            } else {
                analysisState = new AnalysisState(Long.valueOf(0L), EAnalysisState.INITIAL_ANALYSIS, null);
            }
        }
        return analysisState;
    }

    private boolean isDefaultBranchWithNoRepositoryConnectors(String branchName) throws StorageException {
        if (!branchName.equals(this.getDefaultBranchName())) {
            return false;
        }
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)this.getProjectStorageSystem());
        List repositoryConnectors = projectConfiguration.getConnectorsByNames((Set)ERepositoryConnector.getReadableNames());
        return repositoryConnectors.isEmpty();
    }
}

