/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/postponed-rollbacks")
public class PostponedRollbackService
extends ApiBase {
    @GET
    @Operation(summary="Get postponed rollbacks", description="Returns all postponed rollbacks that are currently pending for the project.", tags={"Project", "Administration"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public List<PostponedRollbackIndex.PostponedRollback> getAllPostponedRollbacks() throws StorageException {
        return this.openProjectIndex(PostponedRollbackIndex.class, null).getAllPostponedRollbacks();
    }

    @POST
    @Path(value="execute/{id}")
    @Operation(summary="Execute postponed rollback", description="Executes the postponed rollback of given id right now.", tags={"Project", "Administration"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public void executePostponedRollback(@PathParam(value="id") String id) throws StorageException {
        PostponedRollbackIndex postponedRollbackIndex = this.openProjectIndex(PostponedRollbackIndex.class, null);
        PostponedRollbackIndex.PostponedRollback postponedRollback = (PostponedRollbackIndex.PostponedRollback)postponedRollbackIndex.getPostponedRollbackById(id).orElseThrow(() -> new NotFoundException("Unknown pending rollback: " + id));
        RollbackRequestedCommitDescriptor rollbackCommit = new RollbackRequestedCommitDescriptor(postponedRollback.rollbackCommits, "Execution of postponed rollback: " + postponedRollback.reason);
        rollbackCommit.setMayNotBePostponed(true);
        JobDescriptor rollbackJob = new JobDescriptor(this.serviceInfo.getInternalId(), ForceRollbackTrigger.class, (CommitDescriptor)rollbackCommit, "Execution of postponed rollback", rollbackCommit.getRollbackId());
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), rollbackJob);
    }
}

