/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.resource.element_details.PrependDirectivesDetail;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ProjectServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/projects/{project}/reanalysis")
public class ProjectReanalysisService
extends ApiBase {
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @POST
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Trigger project reanalysis", description="Triggers reanalysis of the project specified in the path parameter.", tags={"Project"})
    public void triggerReanalysis(@PathParam(value="project") PublicProjectId projectId, @Parameter(description="Indicates whether to only update the findings schema without re-analysis.") @QueryParam(value="only-findings-schema-update") boolean onlyFindingsSchemaUpdate, @Parameter(description="The name of the analysis profile for which the schema should be updated.") @QueryParam(value="analysis-profile-name") String analysisProfileName, @Parameter(description="Whether the project should be validated when triggering the reanalysis") @QueryParam(value="validate-project") @DefaultValue(value="true") boolean validateProject) throws StorageException {
        if (onlyFindingsSchemaUpdate) {
            AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
            ProjectReanalysisService.updateFindingsSchema((IProjectId)projectId, analysisProfileIndex, this.serviceInfo, analysisProfileName);
        } else {
            InternalProjectId internalProjectId = this.openGlobalIndex(ProjectIndex.class).resolveToInternalId((IProjectId)projectId);
            ProjectServiceUtils.triggerReanalysis(internalProjectId, this.serviceInfo, validateProject);
        }
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectId, "Project reanalysis event");
    }

    public static void updateFindingsSchema(IProjectId projectId, AnalysisProfileIndex analysisProfileIndex, ITeamscaleServiceInfo serviceInfo, @Nullable String analysisProfileName) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = serviceInfo.getProjectStorageSystem(projectId);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        if (analysisProfileName != null) {
            ProjectReanalysisService.updateFindingsSchemaForAnalysisProfile(analysisProfileIndex, serviceInfo, analysisProfileName, projectMetaIndex, projectConfiguration, (ProjectStorageSystem)projectStorageSystem);
        } else {
            for (CodeScope codeScope : projectConfiguration.getCodeScopes()) {
                AnalysisProfile embeddedProfile = codeScope.getEmbeddedProfile();
                CCSMAssert.isNotNull((Object)embeddedProfile, (String)"expected embedded profile to exist when updating the findings schema");
                ProjectReanalysisService.updateFindingsSchemaForAnalysisProfile(analysisProfileIndex, serviceInfo, embeddedProfile.getName(), projectMetaIndex, projectConfiguration, (ProjectStorageSystem)projectStorageSystem);
            }
        }
    }

    private static void updateFindingsSchemaForAnalysisProfile(AnalysisProfileIndex analysisProfileIndex, ITeamscaleServiceInfo serviceInfo, String analysisProfileName, MetaIndex projectMetaIndex, ProjectConfiguration projectConfiguration, ProjectStorageSystem projectStorageSystem) throws StorageException {
        AnalysisProfile profile = AnalysisProfileUtils.updateAnalysisProfile((AnalysisProfileIndex)analysisProfileIndex, (MetaIndex)projectMetaIndex, (ProjectConfiguration)projectConfiguration, (String)analysisProfileName);
        try {
            IndexLayer dummyIndexLayer = ProjectValidationUtils.createDummyProject(List.of(profile), null, (GlobalStorageSystem)serviceInfo.getGlobalStorageSystem(), (boolean)true);
            ProjectStorageSystem dummyProjectPartition = ProjectValidationUtils.getDummyProjectPartition((IndexLayer)dummyIndexLayer);
            ProjectReanalysisService.copyProjectInfos(projectStorageSystem, dummyProjectPartition, projectConfiguration.getCodeScopeNamesForAnalysisProfile(profile.getName()));
        }
        catch (ProjectConfigurationException | TriggerCompilationException e) {
            throw new InternalServerErrorException("Could not create a dummy project to update findings schema.", e);
        }
    }

    private static void copyProjectInfos(ProjectStorageSystem projectStorageSystem, ProjectStorageSystem dummyProjectPartition, List<CodeScopeName> codeScopeNames) throws StorageException {
        FindingsSchemaIndex dummyFindingSchemaIndex = (FindingsSchemaIndex)dummyProjectPartition.openProjectIndex(FindingsSchemaIndex.class, null);
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        MetaIndex dummyMetaIndex = (MetaIndex)dummyProjectPartition.openProjectIndex(MetaIndex.class, null);
        metaIndex.setValue((MetaIndex.IMetaIndexEntry)((PrependDirectivesDetail)dummyMetaIndex.getValue(PrependDirectivesDetail.class)), PrependDirectivesDetail.class);
        FindingsSchemaIndex findingSchemaIndex = (FindingsSchemaIndex)projectStorageSystem.openProjectIndex(FindingsSchemaIndex.class, null);
        for (CodeScopeName codeScopeName : codeScopeNames) {
            findingSchemaIndex.setFindingsSchema(dummyFindingSchemaIndex.getFindingsSchema(codeScopeName), codeScopeName);
            findingSchemaIndex.setFindingTypeDescriptions(codeScopeName, dummyFindingSchemaIndex.getCodeScopeSpecificFindingTypeDescriptions(codeScopeName));
        }
    }
}

