/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.teamscale.index.quality_report.retrospective.Retrospective;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.reports.QualityArtifactValidator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class QualityRetrospectiveValidator
extends QualityArtifactValidator<Retrospective> {
    public QualityRetrospectiveValidator(Retrospective qualityArtifact, ITeamscaleServiceInfo serviceInfo) {
        super(qualityArtifact, serviceInfo);
    }

    @Override
    protected List<String> validateArtifact(Function<IProjectId, ProjectStorageSystem> storageSystemAccessor) throws StorageException {
        List<String> errors = super.validateArtifact(storageSystemAccessor);
        Set duplicates = CollectionUtils.getDuplicates(this.getReferencedProjects());
        if (!duplicates.isEmpty()) {
            errors.add("Duplicate referenced projects: " + String.valueOf(duplicates));
        }
        return errors;
    }

    @Override
    protected List<PublicProjectId> getReferencedProjects() {
        return ((Retrospective)this.qualityArtifact).getReferencedProjects();
    }
}

