/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.repository.BranchesInfo;
import com.teamscale.service.repository.BranchesServiceRequestOptions;
import com.teamscale.service.repository.IGlobalBranchesServiceApi;
import com.teamscale.service.repository.ProjectBranchesService;
import com.teamscale.service.repository.ProjectRecentBranchesService;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/branches")
public class GlobalBranchesService
extends ApiBase
implements IGlobalBranchesServiceApi {
    @Override
    public BranchesInfo getGlobalBranchesGetRequest(List<PublicProjectId> projectIds, BranchesServiceRequestOptions branchesServiceRequestOptions) throws StorageException {
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), projectIds);
        if (projects.isEmpty()) {
            return new BranchesInfo();
        }
        String username = this.getUser().getUsername();
        BranchesInfo mergedBranchesInfo = this.getBranchesInfo(projects, username, branchesServiceRequestOptions.isOnlyLive());
        return ProjectBranchesService.getSortedAndPaginatedBranchesInfo(mergedBranchesInfo, branchesServiceRequestOptions);
    }

    @Override
    public String getGlobalFirstUIBranchGetRequest(List<PublicProjectId> projectIds) throws StorageException {
        if (projectIds.isEmpty()) {
            projectIds = this.getIndexLayer().openProjectIndex().getAllPrimaryPublicProjectIds();
        }
        projectIds = CollectionUtils.filterWithException(projectIds, projectId -> this.getIndexLayer().openProjectIndex().tryResolveProject((IProjectId)projectId).map(projectInfo -> !projectInfo.isDeleting()).orElse(false));
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), (List)projectIds);
        if (projects.isEmpty()) {
            return null;
        }
        List defaultBranchNamesList = CollectionUtils.mapWithException((Collection)projects, projectId -> {
            String defaultBranchName = ((MetaIndex)this.serviceInfo.getProjectStorageSystem((IProjectId)projectId).openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
            return this.getPreselectedUIBranchName((PublicProjectId)projectId).orElse(defaultBranchName);
        });
        return (String)CollectionUtils.getAny((Iterable)defaultBranchNamesList);
    }

    private Optional<String> getPreselectedUIBranchName(PublicProjectId projectId) throws StorageException {
        return this.getIndexLayer().openProjectIndex().tryResolveProject((IProjectId)projectId).flatMap(projectInfo -> Optional.ofNullable(projectInfo.getPreselectedUIBranch()));
    }

    @Override
    public List<String> getGlobalRecentBranchesGetRequest(List<PublicProjectId> projectIds) throws StorageException {
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), projectIds);
        if (projects.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List recentBranches = CollectionUtils.mapWithException((Collection)projects, project -> {
            ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)this.serviceInfo.getProjectStorageSystem((IProjectId)project).openProjectIndex(ProjectRepositoryChangeIndex.class, null);
            UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex = (UserRecentlyInteractedBranchesIndex)this.serviceInfo.getProjectStorageSystem((IProjectId)project).openProjectIndex(UserRecentlyInteractedBranchesIndex.class, null);
            ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
            return ProjectRecentBranchesService.getRecentBranches(this.getPermissions(), userRecentlyInteractedBranchesIndex, repositoryStatus, this.getUser());
        });
        return recentBranches.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private BranchesInfo getBranchesInfo(List<? extends IProjectId> projects, String username, boolean isOnlyLive) throws StorageException {
        List branchesMap = CollectionUtils.mapWithException(projects, project -> {
            ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)this.serviceInfo.getProjectStorageSystem(project).openProjectIndex(ProjectRepositoryChangeIndex.class, null);
            return ProjectBranchesService.getBranchesInfo(this.getPermissions(), isOnlyLive, projectRepositoryChangeIndex, username);
        });
        return (BranchesInfo)branchesMap.stream().reduce(GlobalBranchesService::mergeBranchesInfo).get();
    }

    private static BranchesInfo mergeBranchesInfo(BranchesInfo first, BranchesInfo second) {
        HashSet mergedLiveBranches = CollectionUtils.unionSet(first.getLiveBranches(), (Collection[])new Collection[]{second.getLiveBranches()});
        HashSet mergedDeletedBranches = CollectionUtils.unionSet(first.getDeletedBranches(), (Collection[])new Collection[]{second.getDeletedBranches()});
        HashSet mergedAnonymousBranches = CollectionUtils.unionSet(first.getAnonymousBranches(), (Collection[])new Collection[]{second.getAnonymousBranches()});
        HashSet mergedVirtualBranches = CollectionUtils.unionSet(first.getVirtualBranches(), (Collection[])new Collection[]{second.getVirtualBranches()});
        mergedDeletedBranches.removeAll(mergedLiveBranches);
        mergedAnonymousBranches.removeAll(mergedLiveBranches);
        mergedAnonymousBranches.removeAll(mergedDeletedBranches);
        BranchesInfo mergedBranchesInfo = new BranchesInfo();
        if (!mergedLiveBranches.isEmpty()) {
            mergedBranchesInfo.addLiveBranches(mergedLiveBranches);
        }
        if (!mergedDeletedBranches.isEmpty()) {
            mergedBranchesInfo.addDeletedBranches(mergedDeletedBranches);
        }
        if (!mergedAnonymousBranches.isEmpty()) {
            mergedBranchesInfo.addAnonymousBranches(mergedAnonymousBranches);
        }
        if (!mergedVirtualBranches.isEmpty()) {
            mergedBranchesInfo.addVirtualBranches(mergedVirtualBranches);
        }
        return mergedBranchesInfo;
    }
}

