/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.requirements_tracing.index.SpecItemIndexCleanupTrigger;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/spec-items/debug/cleanup")
public class SpecItemCleanupService
extends ApiBase {
    @POST
    @Operation(summary="Run spec item index cleanup", description="Deletes all data from spec item indexes to refill them on the next synchronizer run.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void runSpecItemCleanup(@Parameter(description="Name of the project to cleanup the spec item indexes for") @PathParam(value="project") PublicProjectId projectId) throws StorageException {
        this.getPermissions().checkProjectPermission((IProjectId)projectId, EProjectPermission.EDIT);
        InternalProjectId internalProjectId = this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId);
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), new JobDescriptor(internalProjectId, SpecItemIndexCleanupTrigger.class, null, (Object)this.getUser().getUsername(), "Scheduled through the database cleanup service by the user '" + this.getUser().getUsername() + "'."));
    }
}

