/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.roles.debug;

import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.SubjectRoleAssignments;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

@Path(value="api/roles/debug/subject-role-assignments")
public class SubjectRoleAssignmentsDebugService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get inconsistent group role assignments", description="Returns role assignments for groups which renaming led to different group names in the key and the subject id.", tags={"Permission", "Debugging"})
    @Produces(value={"text/plain"})
    public String getInconsistentSubjectRoleMappings() throws StorageException {
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        List inconsistentGroupAndRoleAssignments = permissionIndex.getInconsistentGroupsAndRoleAssignments();
        return SubjectRoleAssignmentsDebugService.generateResultMessage(inconsistentGroupAndRoleAssignments);
    }

    @POST
    @Operation(summary="Fix inconsistent group role assignments", description="Fixes and returns inconsistent role assignments for groups wich renaming led to different group names in the key and the subject id.", tags={"Permission", "Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String fixInconsistentSubjectRoleAssignments() throws StorageException {
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        return permissionIndex.fixInconsistentGroupRoleAssignments();
    }

    private static String generateResultMessage(List<Pair<String, SubjectRoleAssignments>> inconsistentGroupsAndRoleAssignments) {
        StringBuilder stringBuilder = new StringBuilder();
        int numIssues = inconsistentGroupsAndRoleAssignments.size();
        stringBuilder.append("Found ").append(numIssues).append(" issues.\nPlease send a POST request to \"api/debug/subject-role-assignments\" to automatically fix these issues.\n\n");
        stringBuilder.append("Old Group Name\t\tNew Group Name\n\n");
        for (Pair<String, SubjectRoleAssignments> groupAndRoleAssignments : inconsistentGroupsAndRoleAssignments) {
            stringBuilder.append(((SubjectRoleAssignments)groupAndRoleAssignments.getSecond()).getSubjectId()).append("\t\t").append((String)groupAndRoleAssignments.getFirst()).append("\n");
        }
        return stringBuilder.toString();
    }
}

