/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.performance.PerformanceAggregateEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ByteUnit;

@Path(value="api/system/performance/debug/trigger/aggregate.csv")
public class PerformanceAggregateDownloadService
extends PerformanceDataDownloadServiceBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get aggregated trigger performance metrics", description="Allows downloading the performance aggregate data report as CSV.", tags={"Debugging"})
    public Response getAggregatedTriggerPerformanceMetrics() throws StorageException {
        String entity = PerformanceAggregateDownloadService.createCsvContent(this.openPerformanceIndexes());
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"performance-trigger-aggregate.csv");
    }

    public static String createCsvContent(PairList<PublicProjectId, PerformanceIndexBase> performanceIndexes) throws StorageException {
        StringBuilder builder = new StringBuilder();
        builder.append("Project;State;Trigger;Count;");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Trigger Runtime (sec)");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Aggregated Wall Time (sec)");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Parallelism");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Storage Calls");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Storage Time (sec)");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Memory (MB)");
        builder.append("Section Name");
        PerformanceAggregateDownloadService.appendLongRangeHeader(builder, "Section Time (sec)");
        builder.append("\n");
        for (Pair projectWithIndex : performanceIndexes) {
            PublicProjectId projectId = (PublicProjectId)projectWithIndex.getFirst();
            PerformanceIndexBase index = (PerformanceIndexBase)projectWithIndex.getSecond();
            for (PerformanceAggregateEntry aggregate : index.getAllAggregates()) {
                builder.append(projectId).append(";");
                PerformanceAggregateDownloadService.appendPerformanceAggregate(builder, aggregate);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private static void appendPerformanceAggregate(StringBuilder builder, PerformanceAggregateEntry aggregate) {
        builder.append(aggregate.getState()).append(";");
        builder.append(aggregate.getTrigger()).append(";");
        long count = aggregate.getExecutionCount();
        builder.append(count).append(";");
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getTriggerRuntimeMillis(), count, 1000.0);
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getAggregatedWallTimeMillis(), count, 1000.0);
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getTriggerParallelism(), count, 1.0);
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getStorageCalls(), count, 1.0);
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getStorageTimeMillis(), count, 1000.0);
        PerformanceAggregateDownloadService.appendStatistics(builder, aggregate.getMaxMemoryBytes(), count, (double)((int)ByteUnit.MEBIBYTES.toBytes(1L)));
        for (Map.Entry entry : aggregate.getSectionTimeMillis()) {
            builder.append((String)entry.getKey()).append(";");
            PerformanceAggregateDownloadService.appendStatistics(builder, (LongSummaryStatistics)entry.getValue(), count, 1000.0);
        }
    }

    private static void appendLongRangeHeader(StringBuilder builder, String name) {
        builder.append("Sum: ").append(name).append(";");
        builder.append("Avg: ").append(name).append(";");
        builder.append("Min: ").append(name).append(";");
        builder.append("Max: ").append(name).append(";");
    }

    private static void appendStatistics(StringBuilder builder, LongSummaryStatistics statistics, long count, double divider) {
        PerformanceAggregateDownloadService.appendStatistics(builder, count, divider, statistics.getSum(), statistics.getMin(), statistics.getMax());
    }

    private static void appendStatistics(StringBuilder builder, IntSummaryStatistics statistics, long count, double divider) {
        PerformanceAggregateDownloadService.appendStatistics(builder, count, divider, statistics.getSum(), statistics.getMin(), statistics.getMax());
    }

    private static void appendStatistics(StringBuilder builder, long count, double divider, long sum, long min, long max) {
        builder.append((double)sum / divider).append(";");
        if (count == 0L) {
            builder.append("-").append(";");
        } else {
            builder.append((double)sum / (double)count / divider).append(";");
        }
        builder.append((double)min / divider).append(";");
        builder.append((double)max / divider).append(";");
    }
}

