/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.user.User;
import com.teamscale.index.task.CodeSnippet;
import com.teamscale.index.task.ETaskResolution;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.FindingIdWithBranch;
import com.teamscale.index.task.Task;
import com.teamscale.index.user.UserAliasLookup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;

@NoIndexValueClass(rationale="Only used for enhancing the Task in the REST layer")
public class ResolvedTask
extends Task {
    private static final long serialVersionUID = 1L;
    private static final String RESOLVED_AUTHOR_PROPERTY = "resolvedAuthor";
    private static final String RESOLVED_ASSIGNEE_PROPERTY = "resolvedAssignee";
    private static final String RESOLVED_UPDATED_BY_PROPERTY = "resolvedUpdatedBy";
    private static final String OPEN_FINDINGS_COUNT_PROPERTY = "openFindingsCount";
    private static final String RESOLVED_FINDINGS_COUNT_PROPERTY = "resolvedFindingsCount";
    private static final String BLACKLISTED_FINDINGS_COUNT_PROPERTY = "blacklistedFindingsCount";
    @JsonProperty(value="resolvedAuthor")
    private final @Nullable User resolvedAuthor;
    @JsonProperty(value="resolvedAssignee")
    private final @Nullable User resolvedAssignee;
    @JsonProperty(value="resolvedUpdatedBy")
    private final @Nullable User resolvedUpdatedBy;
    @JsonProperty(value="openFindingsCount")
    private final long openFindingsCount;
    @JsonProperty(value="resolvedFindingsCount")
    private final long resolvedFindingsCount;
    @JsonProperty(value="blacklistedFindingsCount")
    private final long blacklistedFindingsCount;

    public ResolvedTask(Task task, UserAliasLookup userAliasLookup, List<TrackedFinding> nonBlacklistedFindings, List<TrackedFinding> blacklistedFindings) {
        super(task);
        this.resolvedAuthor = userAliasLookup.resolveUser(this.getAuthor()).orElse(null);
        this.resolvedAssignee = userAliasLookup.resolveUser(this.getAssignee()).orElse(null);
        this.resolvedUpdatedBy = userAliasLookup.resolveUser(this.getUpdatedBy()).orElse(null);
        this.blacklistedFindingsCount = blacklistedFindings.size();
        this.resolvedFindingsCount = nonBlacklistedFindings.stream().filter(finding -> !finding.isAlive()).count();
        this.openFindingsCount = (long)nonBlacklistedFindings.size() - this.resolvedFindingsCount;
    }

    @JsonCreator
    public ResolvedTask(@JsonProperty(value="id") int id, @JsonProperty(value="subject") String subject, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="created") Long created, @JsonProperty(value="updated") Long updated, @JsonProperty(value="status") ETaskStatus status, @JsonProperty(value="resolution") ETaskResolution resolution, @JsonProperty(value="findings") Collection<FindingIdWithBranch> findings, @JsonProperty(value="tags") Collection<String> tags, @JsonProperty(value="resolvedAuthor") User resolvedAuthor, @JsonProperty(value="resolvedAssignee") User resolvedAssignee, @JsonProperty(value="resolvedUpdatedBy") User resolvedUpdatedBy, @JsonProperty(value="openFindingsCount") long openFindingsCount, @JsonProperty(value="resolvedFindingsCount") long resolvedFindingsCount, @JsonProperty(value="blacklistedFindingsCount") long blacklistedFindingsCount, @JsonProperty(value="lastStatusUpdate") Long lastStatusUpdate, @JsonProperty(value="codeSnippets") Collection<CodeSnippet> codeSnippets) {
        super(id, subject, author, description, assignee, created, updated, status, resolution, (Collection)Optional.ofNullable(findings).orElse(new ArrayList()), tags, lastStatusUpdate, codeSnippets);
        this.resolvedAuthor = resolvedAuthor;
        this.resolvedAssignee = resolvedAssignee;
        this.resolvedUpdatedBy = resolvedUpdatedBy;
        this.blacklistedFindingsCount = blacklistedFindingsCount;
        this.resolvedFindingsCount = resolvedFindingsCount;
        this.openFindingsCount = openFindingsCount;
    }

    public long getOpenFindingsCount() {
        return this.openFindingsCount;
    }

    public static List<ResolvedTask> resolve(List<? extends Task> tasks, UserAliasLookup userAliasLookup, Map<Integer, List<TrackedFinding>> taskIdToBlacklistedFindings, Map<Integer, List<TrackedFinding>> taskIdToNonBlacklistedFindings) {
        return CollectionUtils.map(tasks, task -> {
            List nonBlacklistedFindings = (List)taskIdToNonBlacklistedFindings.getOrDefault(task.getId(), (List<TrackedFinding>)CollectionUtils.emptyList());
            List blacklistedFindings = (List)taskIdToBlacklistedFindings.getOrDefault(task.getId(), (List<TrackedFinding>)CollectionUtils.emptyList());
            return new ResolvedTask((Task)task, userAliasLookup, nonBlacklistedFindings, blacklistedFindings);
        });
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)stream);
    }
}

