/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.repository.RepositoryCommitTaskMappingIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.task.ETaskResolution;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.FindingIdWithBranch;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskDiff;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.task.TaskNotificationUtils;
import com.teamscale.index.task.TaskUtils;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.base.ESortOrder;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.tasks.ETaskSortProperty;
import com.teamscale.service.tasks.ResolvedTask;
import com.teamscale.service.tasks.TaskServiceFilterUtils;
import com.teamscale.service.tasks.TaskServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/projects/{project}/tasks")
public class TaskService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private int totalResolvedTaskCount;

    @GET
    @Path(value="{id}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get task", description="Returns the respective task with detailed findings.", tags={"Tasks"})
    public TaskWithDetailedFindings getTask(@Parameter(description="ID of the requested task") @PathParam(value="id") int taskId, @Parameter(description="The branch for which to show the findings status") @QueryParam(value="branch") String branch) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        Task task = TaskServiceFilterUtils.retrieveTask(taskIndex, taskId);
        return this.createTaskWithDetailedFindings(task, userAliasLookup, branch);
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get resolved tasks", description="Returns all available tasks with resolved properties.", tags={"Tasks"})
    public List<ResolvedTask> getResolvedTasks(@BeanParam TaskServiceQueryOptions params) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        return this.getTasks(taskIndex, userAliasLookup, params);
    }

    @GET
    @Path(value="with-count")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get tasks with count", description="Returns all available tasks with count.", tags={"Tasks"})
    public TasksWithCount getTasksWithCount(@BeanParam TaskServiceQueryOptions params) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        List<ResolvedTask> resolvedTasks = this.getTasks(taskIndex, userAliasLookup, params);
        return new TasksWithCount(resolvedTasks, this.totalResolvedTaskCount, params.getStartIndex() + resolvedTasks.size());
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TASKS})
    @Operation(summary="Create task", description="Creates a new task.", tags={"Tasks"})
    public Task createTask(@RequestBody Task task) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        int id = 1 + taskIndex.getAllTasks().size();
        this.createNewTask(task, id);
        this.ensureNoDuplicateFindingIds(task);
        this.ensureNoBlankTags(task);
        taskIndex.setTask(id, task);
        return task;
    }

    @GET
    @Path(value="tags")
    @Operation(summary="Get task tags", description="Allows to retrieve all used task tags.", tags={"Tasks"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getTaskTags() throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        List tasks = taskIndex.getAllTasks();
        return TaskUtils.getAllTags((List)tasks);
    }

    @GET
    @Path(value="{id}/commits")
    @Operation(summary="Get task commits", description="Returns the timestamps of commits associated with a given task.", tags={"Tasks"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<CommitDescriptor> getCommitsForTask(@Parameter(description="ID of the requested task") @PathParam(value="id") int taskId) throws StorageException {
        RepositoryCommitTaskMappingIndex index = this.openProjectIndex(RepositoryCommitTaskMappingIndex.class, null);
        return index.getCommitsForTask(String.valueOf(taskId));
    }

    private void ensureNoBlankTags(Task task) {
        if (task.getTags().stream().noneMatch(String::isBlank)) {
            return;
        }
        task.setTags(CollectionUtils.filter((Collection)task.getTags(), tag -> !tag.isBlank()));
    }

    private void ensureNoDuplicateFindingIds(Task task) {
        HashSet<String> seenIds = new HashSet<String>();
        ArrayList<FindingIdWithBranch> findings = new ArrayList<FindingIdWithBranch>();
        for (FindingIdWithBranch finding : task.getFindings()) {
            if (seenIds.add(finding.getFindingId())) {
                findings.add(finding);
                continue;
            }
            LOGGER.error("Task " + task.getId() + " has duplicate finding: " + finding.getFindingId());
        }
        task.setFindings(findings);
    }

    @PUT
    @Path(value="{id}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_TASKS})
    @Operation(summary="Update task", description="Updates the task with the given ID.", tags={"Tasks"})
    public Task updateTask(@Parameter(description="Task id") @PathParam(value="id") int id, @QueryParam(value="keep-findings") boolean shouldKeepFindings, @RequestBody Task task) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        Task existingTask = TaskServiceFilterUtils.retrieveTask(taskIndex, id);
        this.ensureNoDuplicateFindingIds(task);
        this.ensureNoBlankTags(task);
        task.setId(id);
        this.updateTask(task, existingTask, shouldKeepFindings);
        taskIndex.setTask(id, task);
        return task;
    }

    @PUT
    @Path(value="{id}/status")
    @RequiresProjectPermission(value={EProjectPermission.UPDATE_TASK_STATUS})
    @Operation(summary="Update task status", description="Updates the status of the task with the given ID.", tags={"Tasks"})
    public Task updateTaskStatus(@Parameter(description="Task id") @PathParam(value="id") int id, @RequestBody ETaskStatus newStatus) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        Task existingTask = TaskServiceFilterUtils.retrieveTask(taskIndex, id);
        if (existingTask.getStatus() != newStatus) {
            this.updateStateAndDocumentChanges(existingTask, newStatus, existingTask.getResolution(), taskIndex);
        }
        return existingTask;
    }

    @PUT
    @Path(value="{id}/resolution")
    @RequiresProjectPermission(value={EProjectPermission.UPDATE_TASK_RESOLUTION})
    @Operation(summary="Update task resolution", description="Updates the resolution of the task with the given ID.", tags={"Tasks"})
    public Task updateTaskResolution(@Parameter(description="Task id") @PathParam(value="id") int id, @RequestBody ETaskResolution newResolution) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        Task existingTask = TaskServiceFilterUtils.retrieveTask(taskIndex, id);
        if (existingTask.getResolution() != newResolution) {
            this.updateStateAndDocumentChanges(existingTask, existingTask.getStatus(), newResolution, taskIndex);
        }
        return existingTask;
    }

    private void updateStateAndDocumentChanges(Task task, ETaskStatus status, ETaskResolution resolution, TaskIndex taskIndex) throws StorageException {
        TaskUtils.documentStatusChange((ETaskStatus)status, (ETaskResolution)resolution, (Task)task, (User)this.serviceInfo.getUser(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
        task.setLastStatusUpdate(DateTimeUtils.millisNow());
        task.setStatus(status);
        task.setResolution(resolution);
        taskIndex.setTask(task.getId(), task);
    }

    private List<ResolvedTask> getTasks(TaskIndex taskIndex, UserAliasLookup userAliasLookup, TaskServiceQueryOptions params) throws StorageException {
        List<Task> tasks = taskIndex.getAllTasks();
        tasks = TaskServiceFilterUtils.filterByIds(params, tasks);
        if (params.getSortBy() == ETaskSortProperty.SUMMARY) {
            tasks = TaskServiceFilterUtils.filterByStatus(params, tasks);
            tasks = TaskServiceFilterUtils.applyNonStatusFilters(params, tasks);
        } else {
            tasks = TaskServiceFilterUtils.applyFiltersAndSort(params, tasks);
        }
        this.totalResolvedTaskCount = tasks.size();
        tasks = TaskService.applyMaxResultsParameter(params, tasks);
        List<ResolvedTask> resolvedTasks = this.resolveTasks(tasks, this.readDefaultBranchHead(), userAliasLookup, params.getBranchName());
        if (!params.isDetailsRequested()) {
            for (ResolvedTask task : resolvedTasks) {
                task.setComments(null);
                task.setFindings(null);
            }
        }
        return TaskService.sortBySummaryIfRequired(params, resolvedTasks);
    }

    private static List<ResolvedTask> sortBySummaryIfRequired(TaskServiceQueryOptions params, List<ResolvedTask> resolvedTasks) {
        if (params.getSortBy() == ETaskSortProperty.SUMMARY) {
            Comparator comparator = (t1, t2) -> ObjectUtils.compare((Comparable)Long.valueOf(t1.getOpenFindingsCount()), (Comparable)Long.valueOf(t2.getOpenFindingsCount()));
            if (params.getSortOrder() == ESortOrder.DESCENDING) {
                comparator = comparator.reversed();
            }
            resolvedTasks.sort(comparator);
        }
        return resolvedTasks;
    }

    private static List<Task> applyMaxResultsParameter(TaskServiceQueryOptions params, List<Task> tasks) {
        int end;
        int taskListSize = tasks.size();
        int start = params.getStartIndex();
        int max = params.getMaxResultCount();
        if (max == 0) {
            max = taskListSize;
        }
        if (start >= (end = Math.min(start + max, taskListSize))) {
            return new ArrayList<Task>();
        }
        return tasks.subList(start, end);
    }

    private List<ResolvedTask> resolveTasks(List<Task> tasks, HistoryAccessOption historyAccessOption, UserAliasLookup userAliasLookup, @Nullable String branch) throws StorageException {
        ArrayList<FindingIdWithBranch> findings = new ArrayList<FindingIdWithBranch>();
        ArrayList<String> findingIds = new ArrayList<String>();
        for (Task task : tasks) {
            findings.addAll(task.getFindings());
            findingIds.addAll(task.getFindingIds());
        }
        if (branch != null) {
            findings.forEach(finding -> TaskService.updateFindingBranchName(branch, finding));
        }
        List<TrackedFinding> trackedFindings = this.getFindings(findings);
        List<FindingBlacklistInfo> blacklistInfos = this.getBlacklistInfos(findingIds, historyAccessOption);
        Map<String, TrackedFinding> blacklistedFindings = TaskService.collectBlacklistedFindings(trackedFindings, blacklistInfos);
        Map<String, TrackedFinding> nonBlacklistedFindings = TaskService.collectNonBlacklistedFindings(trackedFindings, blacklistedFindings);
        Map<Integer, List<TrackedFinding>> taskToBlacklistedFindings = TaskService.matchTasksToFindings(tasks, blacklistedFindings);
        Map<Integer, List<TrackedFinding>> taskToNonBlacklistedFindings = TaskService.matchTasksToFindings(tasks, nonBlacklistedFindings);
        return ResolvedTask.resolve(tasks, userAliasLookup, taskToBlacklistedFindings, taskToNonBlacklistedFindings);
    }

    private static Map<Integer, List<TrackedFinding>> matchTasksToFindings(List<Task> tasks, Map<String, TrackedFinding> findings) {
        HashMap<Integer, List<TrackedFinding>> taskToFindings = new HashMap<Integer, List<TrackedFinding>>();
        for (Task task : tasks) {
            for (String findingId : task.getFindingIds()) {
                TrackedFinding finding = findings.get(findingId);
                if (finding == null) continue;
                taskToFindings.computeIfAbsent(task.getId(), x -> new ArrayList()).add(finding);
            }
        }
        return taskToFindings;
    }

    private TaskWithDetailedFindings createTaskWithDetailedFindings(Task task, UserAliasLookup userAliasLookup, @Nullable String branch) throws StorageException {
        List<FindingIdWithBranch> findingIdsWithBranches = task.getFindings().stream().map(FindingIdWithBranch::new).toList();
        if (branch != null) {
            findingIdsWithBranches.forEach(finding -> TaskService.updateFindingBranchName(branch, finding));
        }
        List<TrackedFinding> allFindings = this.getFindings(findingIdsWithBranches);
        List<FindingBlacklistInfo> blacklistInfos = this.getBlacklistInfos(task.getFindingIds(), this.readDefaultBranchHead());
        Map<String, TrackedFinding> blacklistedFindingsAsMap = TaskService.collectBlacklistedFindings(allFindings, blacklistInfos);
        Map<String, TrackedFinding> nonBlacklistedFindingsAsMap = TaskService.collectNonBlacklistedFindings(allFindings, blacklistedFindingsAsMap);
        ArrayList<TrackedFinding> blacklistedFindings = new ArrayList<TrackedFinding>(blacklistedFindingsAsMap.values());
        ArrayList<TrackedFinding> nonBlacklistedFindings = new ArrayList<TrackedFinding>(nonBlacklistedFindingsAsMap.values());
        ResolvedTask resolvedTask = new ResolvedTask(task, userAliasLookup, nonBlacklistedFindings, blacklistedFindings);
        return new TaskWithDetailedFindings(resolvedTask, nonBlacklistedFindings, blacklistedFindings);
    }

    private static void updateFindingBranchName(@NonNull String branch, FindingIdWithBranch finding) {
        if (finding.getBranchName().filter(SpecItemIndex::isRequirementsManagementConnectorBranch).isEmpty()) {
            finding.setBranchName(branch);
        }
    }

    private List<FindingBlacklistInfo> getBlacklistInfos(List<String> findingsIds, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption).getBlacklistInfos(findingsIds);
    }

    private List<TrackedFinding> getFindings(List<FindingIdWithBranch> findingsWithBranch) throws StorageException {
        ArrayList<TrackedFinding> result = new ArrayList<TrackedFinding>();
        String defaultBranch = this.getDefaultBranchName();
        HashMap<String, TrackedFindingsByIdIndex> findingsIndexByBranch = new HashMap<String, TrackedFindingsByIdIndex>();
        for (FindingIdWithBranch findingWithBranch : findingsWithBranch) {
            String findingId = findingWithBranch.getFindingId();
            String branch = findingWithBranch.getBranchName().orElse(defaultBranch);
            TrackedFinding finding = this.getFindingFromBranch(findingsIndexByBranch, branch, findingId);
            if (finding == null && !defaultBranch.equals(branch) && (finding = this.getFindingFromBranch(findingsIndexByBranch, defaultBranch, findingId)) != null) {
                findingWithBranch.setBranchName(defaultBranch);
            }
            if (finding != null) {
                result.add(finding);
                continue;
            }
            LOGGER.warn("Finding with ID " + findingId + " not found on branch " + branch + " or default branch!");
        }
        return result;
    }

    private static Map<String, TrackedFinding> collectNonBlacklistedFindings(List<TrackedFinding> allFindings, Map<String, TrackedFinding> blacklistedFindings) {
        HashMap<String, TrackedFinding> nonBlacklistedFindings = new HashMap<String, TrackedFinding>();
        CollectionUtils.filterAndMap(allFindings, finding -> !blacklistedFindings.containsKey(finding.getId()), finding -> nonBlacklistedFindings.put(finding.getId(), (TrackedFinding)finding));
        return nonBlacklistedFindings;
    }

    private static Map<String, TrackedFinding> collectBlacklistedFindings(List<TrackedFinding> allFindings, List<FindingBlacklistInfo> blacklistInfos) {
        HashMap<String, TrackedFinding> blacklistedFindings = new HashMap<String, TrackedFinding>();
        for (TrackedFinding finding : allFindings) {
            for (FindingBlacklistInfo blacklistInfo : blacklistInfos) {
                if (blacklistInfo == null || !blacklistInfo.getFindingId().equals(finding.getId())) continue;
                blacklistedFindings.put(finding.getId(), finding);
            }
        }
        return blacklistedFindings;
    }

    private TrackedFinding getFindingFromBranch(Map<String, TrackedFindingsByIdIndex> findingsIndexByBranch, String branch, String findingId) throws StorageException {
        if (!findingsIndexByBranch.containsKey(branch)) {
            findingsIndexByBranch.put(branch, this.openProjectIndex(TrackedFindingsByIdIndex.class, HistoryAccessOption.readHead((String)branch)));
        }
        return findingsIndexByBranch.get(branch).getFinding(findingId);
    }

    private void createNewTask(Task task, int id) throws StorageException {
        long now = DateTimeUtils.millisNow();
        task.setCreated(now);
        task.setUpdated(now);
        task.setLastStatusUpdate(now);
        String currentUser = this.getUser().getUsername();
        if (task.getAuthor() == null) {
            task.setAuthor(currentUser);
        }
        task.setUpdatedBy(currentUser);
        task.setStatus(ETaskStatus.OPEN);
        task.setResolution(ETaskResolution.NONE);
        task.setId(id);
        TaskNotificationUtils.sendCreationNotification((Task)task, (User)this.serviceInfo.getUser(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }

    private void updateTask(Task updatedTask, Task previousTask, boolean keepFindings) throws StorageException {
        if (updatedTask.getUpdated() < previousTask.getUpdated()) {
            throw new IllegalStateException("This task has already been modified. Reload the page to edit the newest version of the task.");
        }
        updatedTask.setCreated(previousTask.getCreated());
        updatedTask.setAuthor(previousTask.getAuthor());
        if (previousTask.getComments() == null) {
            updatedTask.setComments(null);
        } else {
            updatedTask.setComments(new ArrayList(previousTask.getComments()));
        }
        if (keepFindings) {
            updatedTask.setFindings(new ArrayList(previousTask.getFindings()));
        }
        if (updatedTask.getStatus() == previousTask.getStatus()) {
            updatedTask.setLastStatusUpdate(previousTask.getLastStatusUpdate());
        } else {
            updatedTask.setLastStatusUpdate(DateTimeUtils.millisNow());
        }
        List<TrackedFinding> updatedTaskFindings = this.getFindings(updatedTask.getFindings());
        List<TrackedFinding> previousTaskFindings = this.getFindings(previousTask.getFindings());
        TaskDiff taskDiff = new TaskDiff(updatedTask, previousTask, updatedTaskFindings, previousTaskFindings);
        TaskUtils.documentChanges((TaskDiff)taskDiff, (User)this.serviceInfo.getUser(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }

    protected static final class TaskWithDetailedFindings
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="task")
        private final ResolvedTask task;
        @JsonProperty(value="findings")
        private final List<TrackedFinding> findings;
        @JsonProperty(value="blacklistedFindings")
        private final List<TrackedFinding> blacklistedFindings;

        public TaskWithDetailedFindings(ResolvedTask task, List<TrackedFinding> findings, List<TrackedFinding> blacklistedFindings) {
            this.task = task;
            this.findings = findings;
            this.blacklistedFindings = blacklistedFindings;
        }
    }

    private static class TasksWithCount {
        @JsonProperty(value="tasks")
        private final List<ResolvedTask> tasks;
        @JsonProperty(value="totalTaskCount")
        private final int totalTaskCount;
        @JsonProperty(value="nextStartIndex")
        private final int nextStartIndex;

        public TasksWithCount(Collection<ResolvedTask> tasks, int totalTaskCount, int nextStartIndex) {
            this.tasks = new ArrayList<ResolvedTask>(tasks);
            this.totalTaskCount = totalTaskCount;
            this.nextStartIndex = nextStartIndex;
        }
    }
}

