/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitChangeRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitRepositoryDto;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/azure-devops-git/web-hook")
public class AzureDevOpsWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PULL_REQUEST_DESCRIPTION_UPDATED_MESSAGE_REGEX = Pattern.compile("^.+updated\\spull\\srequest.+", 32);

    public AzureDevOpsWebHookService() {
        super(AzureDevOpsGitChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from Azure DevOps Services and Server.", description="Handles the incoming requests from the Bitbucket on-premise server and processes the request body depending on the event. The events which are handled by the service are 'git.push', 'git.pullrequest.created' and 'git.pullrequest.updated'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHooks(@RequestBody WebHookPayload payload) {
        if (LOGGER.isDebugEnabled()) {
            String serializedPayload = JsonUtils.serializeToJSON((Object)payload);
            LOGGER.debug("Received a web hook request from Azure Dev Ops with event \"{}\" and payload: {}", (Object)payload.eventType, (Object)serializedPayload);
        }
        try {
            switch (payload.eventType) {
                case "git.push": {
                    this.handlePushEvent(payload);
                    break;
                }
                case "git.pullrequest.created": 
                case "git.pullrequest.updated": {
                    this.handlePullRequestEvent(payload);
                    break;
                }
            }
        }
        catch (StorageException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    private void handlePushEvent(WebHookPayload payload) throws StorageException {
        String repositoryFullName = payload.resource.repository.getProjectName() + "/" + payload.resource.repository.getName();
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)repositoryFullName, (IndexLayer)this.serviceInfo.getIndexLayer(), null);
    }

    private void handlePullRequestEvent(WebHookPayload content) throws StorageException {
        if (PULL_REQUEST_DESCRIPTION_UPDATED_MESSAGE_REGEX.matcher(content.message.text).matches()) {
            return;
        }
        String repositoryFullName = content.resource.repository.getProjectName() + "/" + content.resource.repository.getName();
        if ("abandoned".equals(content.resource.status)) {
            this.deleteMergeRequestsFromIndex(new MergeRequestIdentifier(repositoryFullName, (long)content.resource.pullRequestId));
            return;
        }
        this.scheduleMergeRequestUpdateTriggers(repositoryFullName, content.resource.pullRequestId, AzureDevOpsGitMergeRequestUpdateTrigger.class, null);
    }

    public static class WebHookPayload {
        @JsonProperty(value="eventType")
        private String eventType;
        @JsonProperty(value="message")
        private Message message;
        @JsonProperty(value="resource")
        private Resource resource;
    }

    private static class Resource {
        @JsonProperty(value="repository")
        private AzureDevOpsGitRepositoryDto repository;
        @JsonProperty(value="pullRequestId")
        private int pullRequestId;
        @JsonProperty(value="status")
        private @Nullable String status;

        private Resource() {
        }
    }

    private static class Message {
        @JsonProperty(value="text")
        private String text;

        private Message() {
        }
    }
}

