/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="api/disable-webhook-creation-default")
public class DisableWebhookCreationService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresNoPermission
    @Operation(summary="Returns the default value for 'Disable automatic webhook creation'", description="Returns the default value for 'Disable automatic webhook creation' specified by JVM flags.")
    public boolean getDefaultForDisableWebhookCreation() {
        return WebHookBasedGitRepositoryConnectorDescriptorBase.DISABLE_AUTOMATIC_WEBHOOK_CREATION;
    }

    @GET
    @RequiresNoPermission
    @Operation(description="Returns if the legacy default for 'Disable automatic webhook creation' is enabled, if the user has admin permissions")
    @Path(value="legacy")
    public boolean showLegacyWebHookWarning() {
        if (!this.getPermissions().createPermissionSummary().isAdmin()) {
            return false;
        }
        if (WebHookBasedGitRepositoryConnectorDescriptorBase.LEGACY_DISABLE_AUTOMATIC_WEBHOOK_CREATION) {
            String legacyFlagName = Boolean.getBoolean("com.teamscale.mergerequest.disable-automatic-webhook-creation") ? "com.teamscale.mergerequest.disable-automatic-webhook-creation" : "com.teamscale.feature-toggle.disable-automatic-webhook-creation";
            LOGGER.warn("You currently have a JVM flag that is no longer supported: '{}'. Please change it to '{}'", (Object)legacyFlagName, (Object)"com.teamscale.mergerequest.disable-automatic-webhook-creation-default");
        }
        return WebHookBasedGitRepositoryConnectorDescriptorBase.LEGACY_DISABLE_AUTOMATIC_WEBHOOK_CREATION;
    }
}

