/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.string.StringUtils;

public class IecCoverageReportParser
extends CoverageReportParserBase {
    private static final Pattern PATTERN = Pattern.compile("\\d+\\.\\s*\\((\\d+)/\\d+\\)\\s*-\\s*\\((\\d+)/\\d+\\)\\s+([^\\s]+)\\s*;\\s*(\\d+)");

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) {
        List lines = StringUtils.splitLinesAsList((String)report);
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = ((String)lines.get(lineNumber)).trim();
            if (lineNumber == 0 || StringUtils.isEmpty((String)line) || line.startsWith("md5")) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) {
                LOGGER.warn("Could not parse line {} which is not in expected format!", (Object)(lineNumber + 1));
                continue;
            }
            int startLine = Integer.parseInt(matcher.group(1));
            int endLine = Integer.parseInt(matcher.group(2));
            String path = matcher.group(3);
            int hits = Integer.parseInt(matcher.group(4));
            path = path.replace('\\', '/');
            ELineCoverage coverageType = ELineCoverage.FULLY_COVERED;
            if (hits == 0) {
                coverageType = ELineCoverage.NOT_COVERED;
            }
            LineCoverageInfo coverageInfo = retriever.getOrCreateLineCoverageInfo(path);
            coverageInfo.addRangeCoverage(startLine, endLine, coverageType);
        }
    }
}

