/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.utils;

import java.io.IOException;
import java.io.Reader;

public class UnsynchronizedStringReader
extends Reader {
    private final String string;
    private final int length;
    private int next = 0;

    public UnsynchronizedStringReader(String string) {
        this.string = string;
        this.length = string.length();
    }

    @Override
    public int read() throws IOException {
        if (this.next >= this.length) {
            return -1;
        }
        return this.string.charAt(this.next++);
    }

    @Override
    public int read(char[] targetBuffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int count = Math.min(this.length - this.next, length);
        this.string.getChars(this.next, this.next + count, targetBuffer, offset);
        this.next += count;
        return count;
    }

    @Override
    public void close() throws IOException {
    }
}

