/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.util;

import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.framework.versioning.VersionedMediaTypeUtils;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ResponseUtils {
    public static <T, VERSION extends Enum<VERSION>> Response toFileDownload(T payload, VERSION version, String fileName) {
        try {
            return ResponseUtils.getFileDownloadResponse(StringUtils.stringToBytes((String)TeamscaleVersionContainer.toJson(payload, version)), MediaType.APPLICATION_JSON_TYPE, fileName);
        }
        catch (JsonSerializationException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static Response getFileDownloadResponse(Object entity, MediaType contentType, String fileName) {
        return ResponseUtils.getFileDownloadResponse(entity, contentType, fileName, -1L);
    }

    public static Response getFileDownloadResponse(Object entity, MediaType contentType, String fileName, long fileSize) {
        StringBuilder downloadFileName = new StringBuilder();
        String filenameWithoutExtension = FileSystemUtils.getFilenameWithoutExtension((String)fileName);
        downloadFileName.append(FileSystemUtils.toSafeFilename((String)filenameWithoutExtension));
        String extension = FileSystemUtils.getFileExtension((String)fileName);
        if (extension != null) {
            downloadFileName.append('.').append(FileSystemUtils.toSafeFilename((String)extension));
        }
        Response.ResponseBuilder response = Response.ok((Object)entity, (MediaType)contentType).header("Content-Disposition", (Object)("attachment; filename = \"" + String.valueOf(downloadFileName) + "\""));
        if (fileSize >= 0L) {
            response.header("Content-Encoding", (Object)"identity");
            response.header("Content-Length", (Object)fileSize);
        }
        return response.build();
    }

    public static Response getResponseForAsset(String fileName, byte[] content) {
        String extension = FileSystemUtils.getFileExtension((String)fileName);
        MediaType mediaType = (MediaType)MoreMediaTypes.EXTENSIONS.getOrDefault((Object)extension, (Object)MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return Response.ok((Object)content, (MediaType)mediaType).build();
    }

    public static Optional<MediaType> getBestMatchingType(Iterable<MediaType> acceptableTypes, Iterable<MediaType> candidates) {
        CCSMAssert.isNotNull(acceptableTypes, () -> "Expected \"acceptableTypes\" to be not null");
        CCSMAssert.isNotNull(candidates, () -> "Expected \"candidates\" to be not null");
        for (MediaType acceptableMediaType : acceptableTypes) {
            for (MediaType candidate : candidates) {
                if (!VersionedMediaTypeUtils.convertToNonVersionedMediaType(acceptableMediaType).isCompatible(candidate)) continue;
                return Optional.of(candidate);
            }
        }
        return Optional.empty();
    }

    private ResponseUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

