/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.ai.IAiEngineProvider;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.index.VersionUtil;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.license.LicenseInfoService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;

public class PerspectiveContextTeamscaleInfo {
    @JsonProperty(value="versionDetails")
    public final String versionDetails = VersionUtil.readTeamscaleVersionDetails();
    @JsonProperty(value="version")
    public final ETeamscaleVersion version = ETeamscaleVersion.CURRENT_VERSION;
    @JsonProperty(value="adminContactURL")
    public final String adminContactURL;
    @JsonProperty(value="licenseInfo")
    public final LicenseInfoService.LicenseInfo licenseInfo;
    @JsonProperty(value="enabledFeatureToggles")
    public final Set<EFeatureToggle> enabledFeatureToggles;
    @JsonProperty(value="instanceName")
    public final @Nullable String instanceName;
    @JsonProperty(value="customCss")
    public final @Nullable String customCss;
    @JsonProperty(value="hubspotChatPortalId")
    public final @Nullable Integer hubspotChatPortalId = TeamscaleSystemProperties.HUBSPOT_CHAT_PORTAL_ID.getValue().orElse(null);
    @JsonProperty(value="aiEngines")
    public final List<IAiEngineProvider.AiEngineDescription> aiEngines;

    public PerspectiveContextTeamscaleInfo(String adminUrl, ITeamscaleServiceInfo serviceInfo, @Nullable String customCss, List<IAiEngineProvider.AiEngineDescription> aiEngines) throws StorageException {
        this.adminContactURL = adminUrl;
        this.customCss = customCss;
        this.licenseInfo = PerspectiveContextTeamscaleInfo.createLicenseInfo();
        this.enabledFeatureToggles = PerspectiveContextTeamscaleInfo.getEnabledFeatureToggles();
        this.instanceName = serviceInfo.getServerConfiguration().getInstanceName();
        this.aiEngines = aiEngines;
    }

    private static LicenseInfoService.LicenseInfo createLicenseInfo() {
        LicenseManager manager = LicenseManager.getInstance();
        return new LicenseInfoService.LicenseInfo(manager.getLicense(), manager.getLicenseLocation(), manager.getErrors());
    }

    private static Set<EFeatureToggle> getEnabledFeatureToggles() {
        return Stream.of(EFeatureToggle.values()).filter(EFeatureToggle::isEnabled).collect(Collectors.toSet());
    }
}

