/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.documentation;

import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="openapi.{type:json|yaml}")
public class OpenApiService
extends ApiBase {
    @GET
    @Produces(value={"application/json", "application/yaml"})
    @Operation(summary="Get OpenAPI definition", description="Returns an OpenAPI (formerly known as Swagger) definition for all available services.", tags={"API"}, responses={@ApiResponse(description="The OpenAPI specification", content={@Content(schema=@Schema(implementation=Object.class))})})
    @ApiResponse(content={@Content(schema=@Schema(implementation=Object.class))}, description="default response")
    @RequiresNoPermission
    public Response getOpenApi(@PathParam(value="type") String type, @Parameter(description="Whether to include non-public API services.") @QueryParam(value="include-internal") boolean includeInternal) throws Exception {
        String suffix = includeInternal ? "internal" : "public";
        InputStream openapiAsStream = Resource.of(((Object)((Object)this)).getClass(), (String)("/teamscale-api-" + suffix + ".yaml")).getAsStream();
        OpenAPI openApi = (OpenAPI)Yaml.mapper().readValue(openapiAsStream, OpenAPI.class);
        if (openApi.getServers() == null) {
            openApi.addServersItem(this.getServerConfiguration());
        }
        if (!StringUtils.isEmpty((String)type) && type.trim().equalsIgnoreCase("yaml")) {
            return Response.ok().entity((Object)Yaml.pretty((Object)openApi)).type(MoreMediaTypes.APPLICATION_YAML_TYPE).build();
        }
        return Response.ok((Object)StringUtils.stringToBytes((String)Json.pretty((Object)openApi))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Server getServerConfiguration() {
        return new Server().url(this.serviceInfo.getRequestBaseUri().toString());
    }
}

