/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.eventbus.EventBus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.TokenGeneratorHelper;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectionValidator;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.ConnectionService;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.check.CheckSmartNotificationsSupportedParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.check.CheckSmartNotificationsSupportedResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.common.TransientSonarCloudConnectionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.common.TransientSonarQubeConnectionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.DidChangeCredentialsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.DidUpdateConnectionsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.SonarCloudConnectionConfigurationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.SonarQubeConnectionConfigurationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.org.GetOrganizationParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.org.GetOrganizationResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.org.ListUserOrganizationsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.org.ListUserOrganizationsResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.org.OrganizationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.validate.ValidateConnectionParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.validate.ValidateConnectionResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.common.TokenDto;
import org.sonarsource.sonarlint.core.clientapi.common.UsernamePasswordDto;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationUpdatedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionCredentialsChangedEvent;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.http.HttpClientProvider;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.SonarCloudConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.SonarQubeConnectionConfiguration;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.developers.DevelopersApi;
import org.sonarsource.sonarlint.core.serverapi.organization.OrganizationApi;
import org.sonarsource.sonarlint.core.serverapi.organization.ServerOrganization;

@Named
@Singleton
public class ConnectionServiceImpl
implements ConnectionService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final EventBus clientEventBus;
    private final ConnectionConfigurationRepository repository;
    private final HttpClientProvider httpClientProvider;
    private final TokenGeneratorHelper tokenGeneratorHelper;

    @Inject
    public ConnectionServiceImpl(EventBus clientEventBus, ConnectionConfigurationRepository repository, InitializeParams params, HttpClientProvider httpClientProvider, TokenGeneratorHelper tokenGeneratorHelper) {
        this(clientEventBus, repository, params.getSonarQubeConnections(), params.getSonarCloudConnections(), httpClientProvider, tokenGeneratorHelper);
    }

    ConnectionServiceImpl(EventBus clientEventBus, ConnectionConfigurationRepository repository, List<SonarQubeConnectionConfigurationDto> initSonarQubeConnections, List<SonarCloudConnectionConfigurationDto> initSonarCloudConnections, HttpClientProvider httpClientProvider, TokenGeneratorHelper tokenGeneratorHelper) {
        this.clientEventBus = clientEventBus;
        this.repository = repository;
        this.httpClientProvider = httpClientProvider;
        this.tokenGeneratorHelper = tokenGeneratorHelper;
        initSonarQubeConnections.forEach(c -> repository.addOrReplace(ConnectionServiceImpl.adapt(c)));
        initSonarCloudConnections.forEach(c -> repository.addOrReplace(ConnectionServiceImpl.adapt(c)));
    }

    private static AbstractConnectionConfiguration adapt(SonarQubeConnectionConfigurationDto sqDto) {
        return new SonarQubeConnectionConfiguration(sqDto.getConnectionId(), sqDto.getServerUrl(), sqDto.getDisableNotifications());
    }

    private static AbstractConnectionConfiguration adapt(SonarCloudConnectionConfigurationDto scDto) {
        return new SonarCloudConnectionConfiguration(scDto.getConnectionId(), scDto.getOrganization(), scDto.getDisableNotifications());
    }

    private static void putAndLogIfDuplicateId(Map<String, AbstractConnectionConfiguration> map, AbstractConnectionConfiguration config) {
        if (map.put(config.getConnectionId(), config) != null) {
            LOG.error("Duplicate connection registered: {}", (Object)config.getConnectionId());
        }
    }

    @Override
    public void didUpdateConnections(DidUpdateConnectionsParams params) {
        HashMap newConnectionsById = new HashMap();
        params.getSonarQubeConnections().forEach(config -> ConnectionServiceImpl.putAndLogIfDuplicateId(newConnectionsById, ConnectionServiceImpl.adapt(config)));
        params.getSonarCloudConnections().forEach(config -> ConnectionServiceImpl.putAndLogIfDuplicateId(newConnectionsById, ConnectionServiceImpl.adapt(config)));
        Map<String, AbstractConnectionConfiguration> previousConnectionsById = this.repository.getConnectionsById();
        Map<String, AbstractConnectionConfiguration> updatedConnections = newConnectionsById.entrySet().stream().filter(e -> previousConnectionsById.containsKey(e.getKey())).filter(e -> !((AbstractConnectionConfiguration)previousConnectionsById.get(e.getKey())).equals(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, AbstractConnectionConfiguration> addedConnections = newConnectionsById.entrySet().stream().filter(e -> !previousConnectionsById.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashSet<String> removedConnectionIds = new HashSet<String>(previousConnectionsById.keySet());
        removedConnectionIds.removeAll(newConnectionsById.keySet());
        updatedConnections.values().forEach(this::updateConnection);
        addedConnections.values().forEach(this::addConnection);
        removedConnectionIds.forEach(this::removeConnection);
    }

    @Override
    public void didChangeCredentials(DidChangeCredentialsParams params) {
        this.clientEventBus.post((Object)new ConnectionCredentialsChangedEvent(params.getConnectionId()));
    }

    private void addConnection(AbstractConnectionConfiguration connectionConfiguration) {
        this.repository.addOrReplace(connectionConfiguration);
        this.clientEventBus.post((Object)new ConnectionConfigurationAddedEvent(connectionConfiguration.getConnectionId()));
    }

    private void removeConnection(String removedConnectionId) {
        AbstractConnectionConfiguration removed = this.repository.remove(removedConnectionId);
        if (removed == null) {
            LOG.debug("Attempt to remove connection '{}' that was not registered. Possibly a race condition?", (Object)removedConnectionId);
        } else {
            this.clientEventBus.post((Object)new ConnectionConfigurationRemovedEvent(removedConnectionId));
        }
    }

    private void updateConnection(AbstractConnectionConfiguration connectionConfiguration) {
        String connectionId = connectionConfiguration.getConnectionId();
        AbstractConnectionConfiguration previous = this.repository.addOrReplace(connectionConfiguration);
        if (previous == null) {
            LOG.debug("Attempt to update connection '{}' that was not registered. Possibly a race condition?", (Object)connectionId);
            this.clientEventBus.post((Object)new ConnectionConfigurationAddedEvent(connectionConfiguration.getConnectionId()));
        } else {
            this.clientEventBus.post((Object)new ConnectionConfigurationUpdatedEvent(connectionConfiguration.getConnectionId()));
        }
    }

    @Override
    public CompletableFuture<ValidateConnectionResponse> validateConnection(ValidateConnectionParams params) {
        ServerApiHelper helper = this.buildServerApiHelper(params.getTransientConnection());
        ConnectionValidator connectionValidator = new ConnectionValidator(helper);
        return connectionValidator.validateConnection().thenApply(r -> new ValidateConnectionResponse(r.success(), r.message()));
    }

    @Override
    public CompletableFuture<CheckSmartNotificationsSupportedResponse> checkSmartNotificationsSupported(CheckSmartNotificationsSupportedParams params) {
        ServerApiHelper helper = this.buildServerApiHelper(params.getTransientConnection());
        DevelopersApi developersApi = new ServerApi(helper).developers();
        return CompletableFuture.supplyAsync(() -> new CheckSmartNotificationsSupportedResponse(developersApi.isSupported()));
    }

    @Override
    public CompletableFuture<ListUserOrganizationsResponse> listUserOrganizations(ListUserOrganizationsParams params) {
        ServerApiHelper helper = this.buildSonarCloudNoOrgApiHelper(params.getCredentials());
        return CompletableFuture.supplyAsync(() -> {
            List<ServerOrganization> serverOrganizations = new OrganizationApi(helper).listUserOrganizations(new ProgressMonitor(null));
            return new ListUserOrganizationsResponse(serverOrganizations.stream().map(o -> new OrganizationDto(o.getKey(), o.getName(), o.getDescription())).collect(Collectors.toList()));
        });
    }

    @Override
    public CompletableFuture<GetOrganizationResponse> getOrganization(GetOrganizationParams params) {
        ServerApiHelper helper = this.buildSonarCloudNoOrgApiHelper(params.getCredentials());
        return CompletableFuture.supplyAsync(() -> {
            Optional<ServerOrganization> serverOrganization = new OrganizationApi(helper).getOrganization(params.getOrganizationKey(), new ProgressMonitor(null));
            return new GetOrganizationResponse(serverOrganization.map(o -> new OrganizationDto(o.getKey(), o.getName(), o.getDescription())).orElse(null));
        });
    }

    @NotNull
    ServerApiHelper buildServerApiHelper(Either<TransientSonarQubeConnectionDto, TransientSonarCloudConnectionDto> transientConnection) {
        EndpointParams endpointParams = transientConnection.map(sq -> new EndpointParams(sq.getServerUrl(), false, null), sc -> new EndpointParams(SonarCloudConnectionConfiguration.getSonarCloudUrl(), true, sc.getOrganization()));
        HttpClient httpClient = this.getClientFor(transientConnection.map(TransientSonarQubeConnectionDto::getCredentials, TransientSonarCloudConnectionDto::getCredentials));
        return new ServerApiHelper(endpointParams, httpClient);
    }

    @NotNull
    ServerApiHelper buildSonarCloudNoOrgApiHelper(Either<TokenDto, UsernamePasswordDto> credentials) {
        EndpointParams endpointParams = new EndpointParams(SonarCloudConnectionConfiguration.getSonarCloudUrl(), true, null);
        HttpClient httpClient = this.getClientFor(credentials);
        return new ServerApiHelper(endpointParams, httpClient);
    }

    private HttpClient getClientFor(Either<TokenDto, UsernamePasswordDto> credentials) {
        return credentials.map(tokenDto -> this.httpClientProvider.getHttpClientWithPreemptiveAuth(tokenDto.getToken(), null), userPass -> this.httpClientProvider.getHttpClientWithPreemptiveAuth(userPass.getUsername(), userPass.getPassword()));
    }

    @Override
    public CompletableFuture<HelpGenerateUserTokenResponse> helpGenerateUserToken(HelpGenerateUserTokenParams params) {
        return this.tokenGeneratorHelper.helpGenerateUserToken(params);
    }
}

