/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenParams;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.client.OpenUrlInBrowserParams;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.embedded.server.AwaitingUserTokenFutureRepository;
import org.sonarsource.sonarlint.core.embedded.server.EmbeddedServer;
import org.sonarsource.sonarlint.core.http.HttpClientProvider;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;

@Named
@Singleton
public class TokenGeneratorHelper {
    private static final Version MIN_SQ_VERSION_SUPPORTING_AUTOMATIC_TOKEN_GENERATION = Version.create("9.7");
    private final SonarLintClient client;
    private final EmbeddedServer embeddedServer;
    private final AwaitingUserTokenFutureRepository awaitingUserTokenFutureRepository;
    private final HttpClientProvider httpClientProvider;
    private final String clientName;

    public TokenGeneratorHelper(SonarLintClient client, EmbeddedServer embeddedServer, AwaitingUserTokenFutureRepository awaitingUserTokenFutureRepository, InitializeParams params, HttpClientProvider httpClientProvider) {
        this.client = client;
        this.embeddedServer = embeddedServer;
        this.awaitingUserTokenFutureRepository = awaitingUserTokenFutureRepository;
        this.clientName = params.getClientInfo().getName();
        this.httpClientProvider = httpClientProvider;
    }

    public CompletableFuture<HelpGenerateUserTokenResponse> helpGenerateUserToken(HelpGenerateUserTokenParams params) {
        CompletableFuture<HelpGenerateUserTokenResponse> futureTokenResponse = new CompletableFuture<HelpGenerateUserTokenResponse>();
        CompletableFuture.runAsync(() -> {
            String serverBaseUrl = params.getServerUrl();
            this.doesServerSupportAutomaticUserTokenGeneration(serverBaseUrl, params.isSonarCloud()).handle((automaticTokenGenerationSupported, error) -> {
                boolean shouldWaitIncomingToken;
                if (error != null) {
                    futureTokenResponse.completeExceptionally((Throwable)error);
                    return null;
                }
                this.client.openUrlInBrowser(new OpenUrlInBrowserParams(ServerApiHelper.concat(serverBaseUrl, this.getUserTokenGenerationRelativeUrlToOpen((boolean)automaticTokenGenerationSupported))));
                boolean bl = shouldWaitIncomingToken = Boolean.TRUE.equals(automaticTokenGenerationSupported) && this.embeddedServer.isStarted();
                if (shouldWaitIncomingToken) {
                    this.awaitingUserTokenFutureRepository.addExpectedResponse(serverBaseUrl, futureTokenResponse);
                } else {
                    futureTokenResponse.complete(new HelpGenerateUserTokenResponse(null));
                }
                return null;
            });
        });
        return futureTokenResponse;
    }

    private String getUserTokenGenerationRelativeUrlToOpen(boolean automaticTokenGenerationSupported) {
        if (automaticTokenGenerationSupported) {
            return "/sonarlint/auth?ideName=" + UrlUtils.urlEncode(this.clientName) + (String)(this.embeddedServer.isStarted() ? "&port=" + this.embeddedServer.getPort() : "");
        }
        return "/account/security";
    }

    private CompletableFuture<Boolean> doesServerSupportAutomaticUserTokenGeneration(String serverUrl, boolean isSonarCloud) {
        if (!isSonarCloud) {
            EndpointParams endpoint = new EndpointParams(serverUrl, false, null);
            return new ServerApi(endpoint, this.httpClientProvider.getHttpClient()).system().getStatus().thenApply(status -> Version.create(status.getVersion()).satisfiesMinRequirement(MIN_SQ_VERSION_SUPPORTING_AUTOMATIC_TOKEN_GENERATION));
        }
        return CompletableFuture.completedFuture(false);
    }
}

