/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.IssuePattern;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultFilterableIssue;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class EnforceIssuesFilter
implements IssueFilter {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final List<IssuePattern> multicriteriaPatterns;

    public EnforceIssuesFilter(IssueInclusionPatternInitializer patternInitializer) {
        this.multicriteriaPatterns = Collections.unmodifiableList(new ArrayList<IssuePattern>(patternInitializer.getMulticriteriaPatterns()));
    }

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.multicriteriaPatterns) {
            SonarLintInputFile file;
            if (!pattern.matchRule(issue.ruleKey())) continue;
            atLeastOneRuleMatched = true;
            InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
            if (!component.isFile() || !pattern.matchFile((file = (SonarLintInputFile)component).relativePath())) continue;
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue {} enforced by pattern {}", (Object)issue, (Object)matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return chain.accept(issue);
    }
}

