/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.sensor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonarsource.sonarlint.core.analysis.container.analysis.sensor.SensorOptimizer;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultSensorContext;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultSensorDescriptor;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;

public class SensorsExecutor {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SensorOptimizer sensorOptimizer;
    private final ProgressMonitor progress;
    private final List<ProjectSensor> sensors;
    private final DefaultSensorContext context;

    public SensorsExecutor(DefaultSensorContext context, SensorOptimizer sensorOptimizer, ProgressMonitor progress, Optional<List<ProjectSensor>> sensors) {
        this.context = context;
        this.sensors = sensors.orElse(List.of());
        this.sensorOptimizer = sensorOptimizer;
        this.progress = progress;
    }

    public void execute() {
        Map<Boolean, List<ProjectSensor>> sensorGroups = this.sensors.stream().collect(Collectors.partitioningBy(s -> {
            boolean isModernGlobalSensor;
            boolean bl = isModernGlobalSensor = !(s instanceof Sensor);
            if (isModernGlobalSensor) {
                return true;
            }
            DefaultSensorDescriptor descriptor = new DefaultSensorDescriptor();
            s.describe(descriptor);
            return descriptor.isGlobal();
        }));
        List<ProjectSensor> moduleSensors = sensorGroups.get(false);
        List<ProjectSensor> globalSensors = sensorGroups.get(true);
        this.executeSensors(moduleSensors);
        this.executeSensors(globalSensors);
    }

    private void executeSensors(List<ProjectSensor> sensors) {
        for (ProjectSensor sensor : SensorsExecutor.sort(sensors)) {
            this.progress.checkCancel();
            DefaultSensorDescriptor descriptor = new DefaultSensorDescriptor();
            sensor.describe(descriptor);
            if (!this.sensorOptimizer.shouldExecute(descriptor)) continue;
            SensorsExecutor.executeSensor(this.context, sensor, descriptor);
        }
    }

    private static void executeSensor(SensorContext context, ProjectSensor sensor, DefaultSensorDescriptor descriptor) {
        String sensorName = descriptor.name() != null ? descriptor.name() : SensorsExecutor.describe(sensor);
        LOG.debug("Execute Sensor: {}", (Object)sensorName);
        try {
            sensor.execute(context);
        }
        catch (Throwable t) {
            LOG.error("Error executing sensor: '{}'", (Object)sensorName, (Object)t);
        }
    }

    static String describe(Object o) {
        try {
            String str;
            if (o.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class && (str = o.toString()) != null) {
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o.getClass().getName();
    }

    private static <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : SensorsExecutor.getDependencies(extension)) {
                dag.add(extension, dependency);
            }
            for (Object generates : SensorsExecutor.getDependents(extension)) {
                dag.add(generates, extension);
            }
            SensorsExecutor.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return sortedList.stream().filter(extensions::contains).collect(Collectors.toList());
    }

    private static <T> List<Object> getDependencies(T extension) {
        return new ArrayList<Object>(SensorsExecutor.evaluateAnnotatedClasses(extension, DependsUpon.class));
    }

    private static <T> List<Object> getDependents(T extension) {
        return new ArrayList<Object>(SensorsExecutor.evaluateAnnotatedClasses(extension, DependedUpon.class));
    }

    private static void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = SensorsExecutor.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo(name) < 0) {
                dag.add((Object)name, extension);
                continue;
            }
            if (phase.compareTo(name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    private static Phase.Name evaluatePhase(Object extension) {
        Phase phaseAnnotation = AnnotationUtils.getAnnotation(extension, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    static List<Object> evaluateAnnotatedClasses(Object extension, Class<? extends Annotation> annotation) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            SensorsExecutor.evaluateClass(aClass, annotation, results);
        }
        return results;
    }

    private static void evaluateClass(Class<?> extensionClass, Class<? extends Annotation> annotationClass, List<Object> results) {
        Class<?>[] interfaces;
        Annotation annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            SensorsExecutor.evaluateClass(anInterface, annotationClass, results);
        }
    }
}

