/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.BindingSuggestionProviderImpl;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.config.binding.BindingSuggestionDto;
import org.sonarsource.sonarlint.core.clientapi.client.binding.AssistBindingParams;
import org.sonarsource.sonarlint.core.clientapi.client.binding.NoBindingSuggestionFoundParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.AssistCreatingConnectionParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.AssistCreatingConnectionResponse;

public class ShowHotspotOrIssueRequestHandler {
    private final BindingSuggestionProviderImpl bindingSuggestionProvider;
    private final SonarLintClient client;

    public ShowHotspotOrIssueRequestHandler(BindingSuggestionProviderImpl bindingSuggestionProvider, SonarLintClient client) {
        this.bindingSuggestionProvider = bindingSuggestionProvider;
        this.client = client;
    }

    void startFullBindingProcess() {
        this.bindingSuggestionProvider.disable();
    }

    void endFullBindingProcess() {
        this.bindingSuggestionProvider.enable();
    }

    CompletableFuture<AssistCreatingConnectionResponse> assistCreatingConnection(String serverUrl) {
        return this.assistCreatingConnection(serverUrl, null, null);
    }

    CompletableFuture<AssistCreatingConnectionResponse> assistCreatingConnection(String serverUrl, @Nullable String tokenName, @Nullable String tokenValue) {
        return this.client.assistCreatingConnection(new AssistCreatingConnectionParams(serverUrl, tokenName, tokenValue));
    }

    CompletableFuture<NewBinding> assistBinding(Set<String> scopeIds, String connectionId, String projectKey) {
        Map<String, List<BindingSuggestionDto>> suggestions = this.bindingSuggestionProvider.computeBindingSuggestions(scopeIds, Set.of(connectionId), projectKey);
        String configScopeIdSuggested = ShowHotspotOrIssueRequestHandler.findSingleConfigScopeIdFromBindingSuggestions(suggestions, projectKey);
        if (configScopeIdSuggested == null) {
            this.client.noBindingSuggestionFound(new NoBindingSuggestionFoundParams(projectKey));
            return CompletableFuture.completedFuture(new NewBinding(connectionId, null));
        }
        return this.client.assistBinding(new AssistBindingParams(connectionId, projectKey, configScopeIdSuggested)).thenApply(response -> new NewBinding(connectionId, response.getConfigurationScopeId()));
    }

    @Nullable
    static String findSingleConfigScopeIdFromBindingSuggestions(Map<String, List<BindingSuggestionDto>> suggestions, String projectKey) {
        String resultKey = null;
        for (Map.Entry<String, List<BindingSuggestionDto>> entry : suggestions.entrySet()) {
            if (!entry.getValue().stream().anyMatch(dto -> projectKey.equals(dto.getSonarProjectKey()))) continue;
            if (resultKey == null) {
                resultKey = entry.getKey();
                continue;
            }
            return null;
        }
        return resultKey;
    }

    static class NewBinding {
        private final String connectionId;
        private final String configurationScopeId;

        private NewBinding(String connectionId, @Nullable String configurationScopeId) {
            this.connectionId = connectionId;
            this.configurationScopeId = configurationScopeId;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        @Nullable
        public String getConfigurationScopeId() {
            return this.configurationScopeId;
        }
    }
}

