/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import nl.altindag.ssl.model.TrustManagerParameters;
import nl.altindag.ssl.util.CertificateUtils;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.http.CheckServerTrustedParams;
import org.sonarsource.sonarlint.core.clientapi.client.http.X509CertificateDto;

@Named
@Singleton
public class AskClientCertificatePredicate
implements Predicate<TrustManagerParameters> {
    private final SonarLintClient client;

    public AskClientCertificatePredicate(SonarLintClient client) {
        this.client = client;
    }

    @Override
    public boolean test(TrustManagerParameters trustManagerParameters) {
        try {
            return this.client.checkServerTrusted(new CheckServerTrustedParams(Arrays.stream(trustManagerParameters.getChain()).map(c -> new X509CertificateDto(CertificateUtils.convertToPem(c))).collect(Collectors.toList()), trustManagerParameters.getAuthType())).get().isTrusted();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

