/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.core.issuetracking.IssueTrackerCache;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;

public class InMemoryIssueTrackerCache<T>
implements IssueTrackerCache<T> {
    private final Map<String, Collection<Trackable<T>>> cache = new ConcurrentHashMap<String, Collection<Trackable<T>>>();

    @Override
    public boolean isFirstAnalysis(String file) {
        return !this.cache.containsKey(file);
    }

    @Override
    public Collection<Trackable<T>> getCurrentTrackables(String file) {
        return this.cache.getOrDefault(file, Collections.emptyList());
    }

    @Override
    public Collection<Trackable<T>> getLiveOrFail(String file) {
        Collection<Trackable<T>> trackables = this.cache.get(file);
        if (trackables == null) {
            throw new IllegalStateException("file should have been already analyzed: " + file);
        }
        return trackables;
    }

    @Override
    public void put(String file, Collection<Trackable<T>> trackables) {
        this.cache.put(file, trackables);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void shutdown() {
    }
}

