/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.local.only;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.sonarsource.sonarlint.core.local.only.XodusLocalOnlyIssueStore;

public class LocalOnlyIssueStorageService {
    private final Path projectsStorageBaseDir;
    private final Path workDir;
    private XodusLocalOnlyIssueStore localOnlyIssueStore;

    public LocalOnlyIssueStorageService(@Named(value="storageRoot") Path storageRoot, @Named(value="userHome") Path workDir) {
        this.projectsStorageBaseDir = storageRoot;
        this.workDir = workDir;
    }

    @PostConstruct
    public void purgeOldIssues() {
        this.get().purgeIssuesOlderThan(Instant.now().minus(7L, ChronoUnit.DAYS));
    }

    public XodusLocalOnlyIssueStore get() {
        if (this.localOnlyIssueStore == null) {
            try {
                this.localOnlyIssueStore = new XodusLocalOnlyIssueStore(this.projectsStorageBaseDir, this.workDir);
                return this.localOnlyIssueStore;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create local-only issue database", e);
            }
        }
        return this.localOnlyIssueStore;
    }

    @PreDestroy
    public void close() {
        if (this.localOnlyIssueStore != null) {
            this.localOnlyIssueStore.close();
        }
    }
}

