/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.newcode;

import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Measures;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;

public class NewCodeApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String GET_NEW_CODE_DEFINITION_URL = "/api/measures/component.protobuf";
    private static final String OLD_SQ_OR_SC_PERIOD = "periods";
    private static final String NEW_SQ_PERIOD = "period";
    private static final Version NEW_SQ_VERSION = Version.create("8.1");
    private final ServerApiHelper helper;

    public NewCodeApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public Optional<NewCodeDefinition> getNewCodeDefinition(String projectKey, @Nullable String branch, Version serverVersion) {
        long date;
        String parameter;
        Measures.ComponentWsResponse response;
        String period = NewCodeApi.getPeriodForServer(this.helper, serverVersion);
        StringBuilder requestPath = new StringBuilder().append(GET_NEW_CODE_DEFINITION_URL).append("?additionalFields=").append(period).append("&metricKeys=projects&component=").append(UrlUtils.urlEncode(projectKey));
        if (branch != null) {
            requestPath.append("&branch=").append(UrlUtils.urlEncode(branch));
        }
        try (HttpClient.Response wsResponse = this.helper.get(requestPath.toString());
             InputStream is = wsResponse.bodyAsStream();){
            response = Measures.ComponentWsResponse.parseFrom(is);
        }
        catch (Exception e) {
            LOG.error("Error while fetching new code definition", e);
            return Optional.empty();
        }
        Measures.Period periodFromWs = NewCodeApi.getPeriodFromWs(response);
        String modeString = periodFromWs.getMode();
        String string = parameter = periodFromWs.hasParameter() ? periodFromWs.getParameter() : null;
        if (modeString.equals("REFERENCE_BRANCH") && parameter != null) {
            return Optional.of(NewCodeDefinition.withReferenceBranch(parameter));
        }
        long l = date = periodFromWs.hasDate() ? ServerApiUtils.parseOffsetDateTime(periodFromWs.getDate()).toInstant().toEpochMilli() : 0L;
        if ((modeString.equals("NUMBER_OF_DAYS") || modeString.equals("days")) && parameter != null) {
            int days = Integer.parseInt(parameter);
            return Optional.of(NewCodeDefinition.withNumberOfDays(days, date));
        }
        if (modeString.equalsIgnoreCase("PREVIOUS_VERSION")) {
            return Optional.of(NewCodeDefinition.withPreviousVersion(date, parameter));
        }
        if (modeString.equals("SPECIFIC_ANALYSIS") || modeString.equals("version") || modeString.equals("date")) {
            return Optional.of(NewCodeDefinition.withSpecificAnalysis(date));
        }
        LOG.warn("Unsupported mode of new code definition: " + modeString);
        return Optional.empty();
    }

    static Measures.Period getPeriodFromWs(Measures.ComponentWsResponse response) {
        if (response.hasPeriods()) {
            return response.getPeriods().getPeriods(0);
        }
        return response.getPeriod();
    }

    static String getPeriodForServer(ServerApiHelper helper, Version serverVersion) {
        if (helper.isSonarCloud()) {
            return OLD_SQ_OR_SC_PERIOD;
        }
        if (serverVersion.compareToIgnoreQualifier(NEW_SQ_VERSION) < 0) {
            return OLD_SQ_OR_SC_PERIOD;
        }
        return NEW_SQ_PERIOD;
    }
}

