/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotRaisedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.TaintVulnerabilityRaisedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.common.LocationPayload;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class SecurityHotspotRaisedEventParser
implements EventParser<SecurityHotspotRaisedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<SecurityHotspotRaisedEvent> parse(String jsonData) {
        HotspotRaisedEventPayload payload = this.gson.fromJson(jsonData, HotspotRaisedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'SecurityHotspotRaised' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new SecurityHotspotRaisedEvent(payload.key, payload.projectKey, VulnerabilityProbability.valueOf(payload.vulnerabilityProbability), HotspotReviewStatus.valueOf(payload.status), Instant.ofEpochMilli(payload.creationDate), payload.branch, TaintVulnerabilityRaisedEventParser.adapt(payload.mainLocation), payload.ruleKey, payload.ruleDescriptionContextKey, payload.assignee));
    }

    private static class HotspotRaisedEventPayload {
        private String key;
        private String projectKey;
        private String status;
        private String branch;
        private String vulnerabilityProbability;
        private long creationDate;
        private String ruleKey;
        private LocationPayload mainLocation;
        @Nullable
        private String ruleDescriptionContextKey;
        @Nullable
        private String assignee;

        private HotspotRaisedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.key) || ServerApiUtils.isBlank(this.projectKey) || ServerApiUtils.isBlank(this.vulnerabilityProbability) || this.creationDate == 0L || ServerApiUtils.isBlank(this.branch) || ServerApiUtils.isBlank(this.ruleKey) || this.mainLocation.isInvalid();
        }
    }
}

