/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.util.Set;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBranches;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;

public class ProjectBranchesStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Path storageFilePath;
    private final RWLock rwLock = new RWLock();

    public ProjectBranchesStorage(Path projectStorageRoot) {
        this.storageFilePath = projectStorageRoot.resolve("project_branches.pb");
    }

    public void store(ProjectBranches projectBranches) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        Sonarlint.ProjectBranches data = ProjectBranchesStorage.adapt(projectBranches);
        LOG.debug("Storing project branches in {}", (Object)this.storageFilePath);
        this.rwLock.write(() -> ProtobufFileUtil.writeToFile(data, this.storageFilePath));
    }

    public ProjectBranches read() {
        return ProjectBranchesStorage.adapt(this.rwLock.read(() -> ProtobufFileUtil.readFile(this.storageFilePath, Sonarlint.ProjectBranches.parser())));
    }

    private static ProjectBranches adapt(Sonarlint.ProjectBranches projectBranches) {
        return new ProjectBranches(Set.copyOf(projectBranches.getBranchNameList()), projectBranches.getMainBranchName());
    }

    private static Sonarlint.ProjectBranches adapt(ProjectBranches projectBranches) {
        return Sonarlint.ProjectBranches.newBuilder().addAllBranchName(projectBranches.getBranchNames()).setMainBranchName(projectBranches.getMainBranchName()).build();
    }
}

