/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;

public class ServerPathProvider {
    private static final String MIN_SQ_VERSION = "9.7";

    private ServerPathProvider() {
    }

    public static CompletableFuture<String> getServerUrlForTokenGeneration(EndpointParams endpoint, HttpClient client, int port, String ideName) {
        ServerApi serverApi = new ServerApi(endpoint, client);
        return serverApi.system().getStatus().thenApply(systemInfo -> ServerPathProvider.buildServerPath(endpoint.getBaseUrl(), systemInfo.getVersion(), port, ideName, endpoint.isSonarCloud()));
    }

    public static CompletableFuture<String> getFallbackServerUrlForTokenGeneration(EndpointParams endpoint, HttpClient client, String ideName) {
        ServerApi serverApi = new ServerApi(endpoint, client);
        return serverApi.system().getStatus().thenApply(systemInfo -> ServerPathProvider.buildServerPath(endpoint.getBaseUrl(), systemInfo.getVersion(), null, ideName, endpoint.isSonarCloud()));
    }

    static String buildServerPath(String baseUrl, String serverVersionStr, @Nullable Integer port, String ideName, boolean isSonarCloud) {
        Version minVersion = Version.create(MIN_SQ_VERSION);
        Version serverVersion = Version.create(serverVersionStr);
        StringBuilder relativePath = new StringBuilder();
        String portParameter = ServerPathProvider.getPortParameter(port);
        if (isSonarCloud || !serverVersion.satisfiesMinRequirement(minVersion)) {
            relativePath.append("/account/security");
        } else {
            relativePath.append("/sonarlint/auth?ideName=").append(UrlUtils.urlEncode(ideName)).append(portParameter);
        }
        return ServerApiHelper.concat(baseUrl, relativePath.toString());
    }

    private static String getPortParameter(@Nullable Integer port) {
        if (port == null) {
            return "";
        }
        return "&port=" + port;
    }
}

