/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.shaded.org.springframework.context.annotation;

import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.parsing.Problem;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.parsing.ProblemReporter;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.Configuration;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.ConfigurationClass;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.ConfigurationMethod;
import org.sonarsource.sonarlint.shaded.org.springframework.core.type.MethodMetadata;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;

final class BeanMethod
extends ConfigurationMethod {
    BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if (this.getMetadata().isStatic()) {
            return;
        }
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error(new NonOverridableMethodError());
        }
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof BeanMethod && this.metadata.equals(((BeanMethod)obj).metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public String toString() {
        return "BeanMethod: " + this.metadata;
    }

    private class NonOverridableMethodError
    extends Problem {
        NonOverridableMethodError() {
            super(String.format("@Bean method '%s' must not be private or final; change the method's modifiers to continue", BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

