This check detects anonymous namespaces used in header files.

# Why is This a Problem?
An anonymous namespace defined in a header file will result in a unique instance of the namespace in each translation unit that includes the header file.
This violates the one-definition rule (ODR), bloats the resulting executable file and might cause unexpected results.

# How Can I Resolve This?
There are several solutions for this issue depending on the exact context.
- If a variable is defined in the anonymous namespace, remove the namespace and make the variable `extern` to make the variable accessible over all translation units.
- If a function is defined in the anonymous namespace, remove the namespace and mark the function with `inline` to guarantee only a single implementation instance of the function at runtime.
- Another option is giving the namespace a name and then use the namespace in classes including the header.

## Example (Before)
```cpp
namespace {
  int x;
}
```
If this variable is used in several translation units, each translation unit operates on its own instance.

## Example (After)

```cpp
extern int x;
```
Now all translation units access the same instance.

# Where Can I Learn More?
## Guidelines
- [SEI CERT C++ Coding Standard: Do not define an unnamed namespace in a header file](https://wiki.sei.cmu.edu/confluence/display/cplusplus/DCL59-CPP.+Do+not+define+an+unnamed+namespace+in+a+header+file)
- [ISO C++ Core Guidelines: Don’t use an unnamed (anonymous) namespace in a header](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#sf21-dont-use-an-unnamed-anonymous-namespace-in-a-header)