Using types forbidden by your project's coding guidelines can lead to unexpected behaviour or compatability issues.
Consider using alternatives types that comply with your project's coding guidelines.

# What Does This Check Look For?

This check detects any use of types from a user-defined list of forbidden types in C++ code.

# Why is This a Problem?

Using certain types might be discouraged due to various reasons such as compatibility issues, potential for misuse, or security concerns.

# How Can I Resolve This?

Replace the types marked as forbidden and consider alternatives based on your project's coding guidelines.

# Examples

## Non-Compliant

```cpp
std::auto_ptr<int> ptr;  // std::auto_ptr is deprecated
```

## Compliant

```cpp
std::unique_ptr<int> ptr;  // std::unique_ptr is a safe and modern alternative
```

# Where Can I Learn More?

- [C++ Core Guidelines](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines)
- [C++ Reference: Smart pointers](https://en.cppreference.com/w/cpp/memory)