Avoid usage of the `var` keyword.

# Why is This a Problem?
The usage of the 'var' keyword is discouraged as it makes the code harder to read, because the result type is not always immediately apparent from the right-hand side, e.g. result method invocations.
It can lead to error-prone code throughout the following usage of the variable.

## Exceptions
It can be justifiable for statements where the right hand side is a literal value or an object allocation.

```Java
var message = "Hello";
var list = new ArrayList<String>();
```

# How Can I Resolve This?
Explicitly state the type of the variable.

## Example (Before)

```Java
var x = "foo";
```

## Example (After)

```Java
String x = "foo";
```

# Where Can I Learn More?

## References
- https://dev.java/learn/using-the-var-type-identifier/