Types must not have the same name as types from `java.lang.*` to avoid confusion.
Consider renaming your types to ensure clarity and avoid naming conflicts with implicitly imported `java.lang` types.

# What Does This Check Look For?

This check reports a finding when a user-defined type uses the same name as any type in the `java.lang` package.

# Why is This a Problem?

Types from the `java.lang` package are automatically imported and widely recognized by Java developers. Creating types with the same name as `java.lang` classes can lead to ambiguity and confusion. It makes it harder for developers to understand which type is being referenced at a glance, potentially leading to errors or unexpected behavior in the code.

# How Can I Resolve This?

To resolve this issue, rename the conflicting custom type to a name that doesn't collide with the classes in the `java.lang` package. Choosing a meaningful and unique name helps in clearly distinguishing custom types from standard Java types, improving code comprehensibility and maintainability.

# Examples

## Non-Compliant

```java
package com.mycompany;

public class String {
    // Non-compliant: This class name conflicts with java.lang.String
}
```

## Compliant

```java
package com.mycompany;

public class CustomString {
    // Compliant: The class name is distinct from java.lang.String
}
```
