Having the same names for class fields and methods can lead to confusion and errors in code understanding.
Consider renaming either the field or the method to clearly differentiate them and improve code readability.

# What Does This Check Look For?

This check identifies instances where a class field and a method within the same class share the same name.

# Why is This a Problem?

Using the same name for both class fields and methods can significantly degrade code readability and understandability.
It can lead to misunderstandings about whether a piece of code is referring to a method call or accessing a field, potentially causing bugs or incorrect assumptions about the code's behavior.
Furthermore, it complicates the maintenance of the codebase by others and may increase the likelihood of errors during future modifications.

# How Can I Resolve This?

To resolve this issue, consider renaming either the method or the field.
Choosing descriptive names that clearly indicate the purpose and nature of both the method and the field can significantly reduce confusion and enhance code readability.
If the method performs an action related to the field, including a verb in the method name (e.g., `getFieldValue` or `setFieldValue`) can also clarify its purpose.

# Examples

The following example is for Java but the same principle applies to C#.

## Non-Compliant

```java
class Employee {
    private String name;
    public String name() {
        return name;
    }
}
```

## Compliant

```java
class Employee {
    private String name;
    public String getName() {
        return name;
    }
}
```