Repeating conditions in boolean expressions can lead to unnecessary complexity and might be a sign of a mistake.
Consider revising the condition to ensure it expresses the intended logic without repetition.

# What Does This Check Look For?

This check flags boolean expressions within control structures (like if, while, and for statements) where the same subcondition is repeated.

# Why is This a Problem?

Repeating conditions in boolean expressions does not add value to the code, since boolean conjunctions (`&&`) and disjunctions (`||`) are idempotent. This means that repeating a condition doesn't change the outcome and only serves to complicate the code. Furthermore, it's often a sign that there has been a mistake or oversight, possibly indicating a missed opportunity to evaluate a different, necessary condition. This can lead to bugs if not recognized and corrected.

# How Can I Resolve This?

Review the logic of the expression to identify and remove the repeated conditions. This simplification not only makes the code easier to read and understand but also helps in identifying any logical errors or conditions that might have been inadvertently omitted. In cases where a condition is repeated, consider whether a different, intended condition was missed and should be included instead.

# Examples

## Non-Compliant

```java
if (a == 3 || a == 3) {...}     // non-compliant: condition 'a == 3' is repeated.
if (a || (b && b)) {...}        // non-compliant: condition 'b' is repeated.
if (a && b && a) {...}          // non-compliant: condition 'a' is repeated.
if ((a && b) || (b && a)) {...} // non-compliant: the combined condition '(a && b)' is repeated.
```

## Compliant

```java
if (a == 3 || b == 3) {...} // compliant: different conditions are checked.
if (a || b) {...}           // compliant: no conditions are repeated.
if (a && b) {...}           // compliant: each condition is unique.
```
